# This file contains platform specific functions some of which require utils.sh
# to be sourced before this file. To avoid a circular reference, users should
# source utils.sh instead of this file to be sure that all references will be
# resolved.

# -----------------------------------------------------------------------------
get_board_name()
{
    board5150=/sys/bus/platform/devices/board_id.1
    board3916=/sys/bus/platform/devices/board_id.2
    board3930=/sys/bus/platform/devices/board_id.3
    board3931=/sys/bus/platform/devices/board_id.4
    board3932=/sys/bus/platform/devices/board_id.5

    if [ -e "$board5150" ]; then
        echo '5150'
    elif [ -e "$board3916" ]; then
        echo '3916'
    elif [ -e "$board3930" ]; then
        echo '3930'
    elif [ -e "$board3931" ]; then
        echo '3931'
    elif [ -e "$board3932" ]; then
        echo '3932'
    else
        echo 'unknown'
    fi
}

# -----------------------------------------------------------------------------
get_local_if()
{
    board=$(get_board_name)
    if [ $board == '5150' ]; then
        echo 'eth0'
    else
        echo 'mgmt0'
    fi
}

# -----------------------------------------------------------------------------
board_has_rtc()
{
    [ "$(get_board_name)" = "5150" -o \
      "$(get_board_name)" = "3930" -o \
      "$(get_board_name)" = "3931" ]
}

# -----------------------------------------------------------------------------
mount_log_partition()
{
    fg_run "mount logs via fstab" /bin/mount /mnt/log
}

# -----------------------------------------------------------------------------
EXIT_BANKA=1
EXIT_BANKB=2
EXIT_NFS=3
EXIT_UNKNOWN=-1
get_running_bank()
{
    case "$(kernel_arg root)" in
        /dev/nfs)  return $EXIT_NFS     ;;
        ubi0:appA) return $EXIT_BANKA   ;;
        ubi0:appB) return $EXIT_BANKB   ;;
        *)         return $EXIT_UNKNOWN ;;
    esac
}

# -----------------------------------------------------------------------------
get_eeprom_file()
{
    board=$(get_board_name)

    if [ $board == '3932' ]; then
        echo /dev/mtd12
    else
        echo /sys/bus/i2c/devices/0-0054/eeprom
    fi
}
