#!/bin/bash
# This script is used with the output generated (/tmp/dsMemUsage.txt)
# when DS_THREAD_STATS flag in enabled in dsList.c 
# Usage: 
# 1) To compute Memory consumed by all threads
# cat /tmp/dsMemUsage.txt | /ciena/scripts/dsMemUsage.sh all
# 2) To compute Memory consumed by specific thread
# cat /tmp/dsMemUsage.txt | /ciena/scripts/dsMemUsage.sh <thread-name>

total=0

# Read a line of input from stdin, and put it into a set of variables.
# If the line has "dsMemUsage" in the right spot, and a poolsize that
# is not an empty string, then add the poolsize to the running total.
#
if [ "$1" == "all" ]; then
   while read tid n name i item1 s item2 p poolsize rest_of_line ; do
      if [ -n "$poolsize" ] ; then
         total=$(expr $poolsize + $total)
      fi
   done
else
   while read tid n name i item1 s item2 p poolsize rest_of_line ; do
      if [ "$name" == "$1" -a -n "$poolsize" ] ; then
         total=$(expr $poolsize + $total)
      fi
   done
fi
echo $total


