# ------------------------------------------------------------------------------
# This function will search the kernel command line for the corresponding
# parameter.  If a match is found, the function returns zero. If the flag arg
# is zero the value of the parameter is returned otherwise an empty string is
# returned.
#
# ------------------------------------------------------------------------------
# $1: argument name
# $2: flag (non-null == true) indicating that the argument has no value
kernel_arg()
{
  [ -n "$1" ] || return 1

  re="^$1"
  [ -n "$2" ] || re="${re}="

  cat /proc/cmdline |
  awk -v re="${re}" 'BEGIN{RS=" +"; status=2};
                     sub(re, "", $0){status=0; print $0; exit};
                     END{exit status}'
}

