#!/bin/sh
#########################################################################
#									#
# Name		: sshKeyGen.sh						#
# Purpose	: Generate the SSH Keys                                 #
#									#
# Usage		:							#
#									#
#									#
#########################################################################


# Delete the SSH Keys if they are present
   if [ -f /mnt/sysfs/ssh/ssh_host_rsa_key ]; then
      rm -f /mnt/sysfs/ssh/ssh_host_rsa_key
   fi
   if [ -f /mnt/sysfs/ssh/ssh_host_rsa_key.pub ]; then
      rm -f /mnt/sysfs/ssh/ssh_host_rsa_key.pub
   fi
#   if [ -f /mnt/sysfs/ssh/ssh_host_dsa_key ]; then
#      rm -f /mnt/sysfs/ssh/ssh_host_dsa_key
#   fi
#   if [ -f /mnt/sysfs/ssh/ssh_host_dsa_key.pub ]; then
#      rm -f /mnt/sysfs/ssh/ssh_host_dsa_key.pub
#   fi

# Generate the keys now.  Make sure that even if we have a real-time
# parent that we make our slow self non-real-time and very nice...
   chrt -o 0 nice /usr/bin/ssh-keygen -q -N "" -f /mnt/sysfs/ssh/ssh_host_rsa_key > /dev/null 2>&1

# Exit with status 
exit 0

# End of stopSSH.sh
