#!/bin/sh
#########################################################################
#									#
# Name		: startSSH.sh						#
# Purpose	: Start SSH daemon					#
#									#
# Usage		: startSSH.sh						#
#									#
#########################################################################

# Ignore SIGINT

# Local declarations
local status=0

# Make sure SSHD is not running
   /ciena/scripts/stopSSH.sh

# SSH is picky about the permission on this
   if [ -d /var/run/sshd ]; then
       chmod 0640 /var/run/sshd
   fi

# SSH is picky about the permission on this
   if [ -f /flash0/ssh/ssh_host_rsa_key ]; then
       chmod 0600 /flash0/ssh/ssh_host_rsa_key
   fi

   sleep 1

# Possible that parent (leos server) could have TZ set.
# Clear TZ so that sshd does not inherit (and pass to clients)
# Let the clients get TZ info from saos/leos when they start
   unset TZ

# Start the SSH daemon, not as a real-time process (our parent LEOS is RT).
   chrt -o 0 /usr/sbin/sshd -f /etc/sshd_config > /dev/null 2>&1
   status=$?

# Check the SSH daemon status
   if [ "$status" -ne "0" ]; then
      echo "$status:  Can't start SSH daemon"
      status=2
   fi

# Exit with status

exit $status

# End of startSSH.sh
