
# Aliases

BASH_COMPLETION_DIR=/etc/bash_completion.d

# source tab completions
if [ -d ${BASH_COMPLETION_DIR} ] ; then
    for i in ${BASH_COMPLETION_DIR}/*.completion
    do
        [ -r $i ] && . $i
    done
fi

alias ll='ls -l'
alias lsf='ls -CF'
alias dir='ls -lhrtp'

path_append /usr/local/bin

# History settings for (diag shell in state-dump) forensic purposes:

# Don't let simultaneous same-user sessions' histories overwrite each other.
shopt -s histappend

# Put multi-line commands on one history line.
shopt -s cmdhist

# Make every command go immediately into on-disk history file.
export PROMPT_COMMAND="history -a"

# Larger (than 500) history file sizes:
export HISTFILESIZE=5000

# Timestamp the history entries within history files:
export HISTTIMEFORMAT=""
