#!/bin/sh
#########################################################################
#                                                                       #
# Name          : restartSSH.sh                                         #
# Purpose       : Restart SSH daemon                                    #
#                                                                       #
# Usage         :                                                       #
#                                                                       #
# restartSSH.sh                                                         #
#                                                                       #
#########################################################################

SSHD_PID_FILE=/var/run/sshd.pid
SSHD_PROG=/usr/sbin/sshd
status=0
tries=0
sshdpidold=
sshdpidnew=

#Check if the PID file exists
if [ -e "$SSHD_PID_FILE" ]; then
    read sshdpidold < $SSHD_PID_FILE
else
    exit $status
fi

#Double-check if the process actually exists in the system
[ ! -d "/proc/$sshdpidold" ] && exit $status

#SSH daemon is running. Restart it
kill -HUP $sshdpidold

# Check the status of the kill command
if [ "$?" -ne "0" ]; then
    status=1
else
    # Wait until the SSH daemon has completed
    # it's restart or we've waited 30 seconds
    read sshdpidnew < $SSHD_PID_FILE
    while [ "$sshdpidold" -eq "$sshdpidnew" -a "$tries" -lt "30" ]; do
        let tries++
        sleep 1
        read sshdpidnew < $SSHD_PID_FILE
    done
    if [ "$tries" -eq "30" ]; then
        status=1
    fi
fi

# Check the SSH daemon status
if [ "$status" -ne "0" ]; then
    echo "Can't restart SSH daemon"
else
    echo "SSH daemon restarted"
fi

# Exit with status
exit $status

# End of restartSSH.sh

