#!/bin/bash

# dhcp client set interface local
# dhcp client enable

# cd /tmp/
# tget 10.1.28.63 sind_top.rbf.gz

# root /ciena/scripts/save_sindar.sh /tmp/sind_top.rbf.gz

fn="sind_top.rbf.gz"

new_img=${1:-/tmp/$fn}

imgA="/mnt/kernelA/$fn"
imgB="/mnt/kernelB/$fn"

if [ -r "$new_img" ]
then
	grep jffs2 /proc/mounts
	mount -o remount,rw -t jffs2 mtd:kernel-a "${imgA%/*}"
	mount -o remount,rw -t jffs2 mtd:kernel-b "${imgB%/*}"
	grep jffs2 /proc/mounts

	cp  "$new_img"  "$imgA"
	cp  "$new_img"  "$imgB"

	sync

	md5sum  "$new_img" "$imgA" "$imgB"
else
	echo "file not found: '$new_img'"
fi

