#!/bin/sh
#########################################################################
#                                                                       #
# Name          : startDhcpc.sh                                         #
# Purpose       : Start DHCP-Client daemon                              #
#                                                                       #
# Usage         :                                                       #
#                                                                       #
#               startDhcpc.sh { <interface> <delay> }                   #
#                                                                       #
#########################################################################

. /ciena/scripts/krn getenv      # Determine normal versus debug 'kernel' mode.

DHCPC_LOG=/tmp/log/udhcpc.log   # NB: Normally not used.
DHCPC_PID=/tmp/etc/udhcpc.pid
REMOTE_NAME=remote
BURST_PER_INTERVAL=1
DHCP_REQUEST_TIMEOUT_DEFAULT=3

#### Interface
if [ "$#" -gt "0" ]; then
   DHCP_INTERFACE=$1
else
   DHCP_INTERFACE=$REMOTE_IFNAME
fi

#### VendorClass
if [ "$#" -gt "1" ]; then
   DHCP_VENDOR_CLASS="$2"
else
   DHCP_VENDOR_CLASS=SAOS.CN0000
fi

#### Discovery-Interval
if [ "$#" -gt "2" ]; then
   if [ $3 -gt $DHCP_REQUEST_TIMEOUT_DEFAULT ]; then
      DHCP_DISC_INTERVAL=`expr $3 - $DHCP_REQUEST_TIMEOUT_DEFAULT`
   else
      DHCP_DISC_INTERVAL=$3
   fi
else
   DHCP_DISC_INTERVAL=30
fi

#### allow caller to set a delay (after client start)
if [ "$#" -gt "3" ]; then
   delay=$4
else
   delay=0
fi

# Make sure DHCPC is not running
/ciena/scripts/stopDhcpc.sh

# Proceeding to start DHCP-C
rm -f $DHCPC_LOG

   # -s script, -i XXX = interface, -V XXX = vendor class, -t N = timeout, -p XXX = pid file
if [ "$KRN_MODE" = "debug" ]; then
    exec >>$DHCPC_LOG	# Use append mode so file truncation works well.
else
    exec >/dev/null
fi
/sbin/udhcpc -S -p $DHCPC_PID -i $DHCP_INTERFACE -a -R -O vivsi -t $BURST_PER_INTERVAL -A $DHCP_DISC_INTERVAL -T $DHCP_REQUEST_TIMEOUT_DEFAULT -V "$DHCP_VENDOR_CLASS" &
exec sleep $delay

# Exit with status (Unreachable, exec above kills this unnecessary shell.)
exit 0

# End of startDhcpc.sh
