#!/bin/bash
source /ciena/scripts/utils.sh

uboot_times=$(kernel_arg ubtimes)
uboot_start=`echo $uboot_times | awk -F',' '{ print $1 }'`
uboot_mount=`echo $uboot_times | awk -F',' '{ print $2 }'`
uboot_fpga=`echo $uboot_times | awk -F',' '{ print $3 }'`
uboot_kernel=`echo $uboot_times | awk -F',' '{ print $4 }'`

echo "U-boot Times in 100ths of a second"
echo "----------------------------------"
echo "u-boot start: $uboot_start"
echo "u-boot mount time:" $[uboot_mount - uboot_start]
echo "u-boot fpga load time:" $[uboot_fpga - uboot_mount]
echo "u-boot kernel hand off time:" $[uboot_kernel - uboot_fpga]
# for now, we will have to get rid of the decimal part of the last uboot time
uboot_final=$[uboot_kernel/100]

# get init complete time (could use first "UBIFS: mounted UBI device" string)
# will then have to find out which bank it booted in and then compare that to the correct string
# example log: 00000223 2013.10.03 16:50:39 KERNEL INFO   [   28.734987] rtc-ds1307 0-0068: setting system clock to 2013-10-03 16:50:36 UTC (1380819036)
kernel_mount=`evt_show | grep 'system clock' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get mount rootfs end time
kernel_mount_end=`evt_show | grep 'VFS' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get handoff to Pid 1 time
pid_1=`evt_show | grep 'Pid 1' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`
echo
echo "Kernel Times in seconds"
echo "-----------------------"
echo "kernel init time:" $[kernel_mount - uboot_final]
echo "kernel root fs time:" $[kernel_mount_end - kernel_mount]
echo "kernel hand-off time:" $[pid_1 - kernel_mount_end]
echo

# 00000238 2013.10.03 16:50:39 KERNEL WARN   [   29.900305] Pid 1: ciena_time 1380819037
boot_time=`evt_show | grep 'Pid 1' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`
epoch_time=`evt_show | grep 'Pid 1' | awk '{ print $11 }'`

# calculate difference between linux start time and cpu start time
diff_time=$[epoch_time-boot_time]

echo
echo "sysinit times in seconds"
echo "------------------------"
#rc_start=`evt_show | grep 'start rcS' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`
rc_start=`evt_show | grep 'start rcS' | awk '{ print $11 }'`
# 00000310 2013.10.03 16:50:59 SYSLOG NOTICE console: rcS        end rcS: ciena_time [ 1380819059 ]
rc_end_temp=`evt_show | grep 'end rcS' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`
#rc_end=$[rc_end_temp-diff_time]
rc_end=$[rc_end_temp-rc_start]
echo "rcS time:" $rc_end

# 00000311 2013.10.03 16:50:59 KERNEL WARN   [   51.572745] start rc.local: ciena_time 1380819059
rc_local_start=`evt_show | grep 'start rc.local' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`
# 00000354 2013.10.03 16:51:29 KERNEL WARN   [   81.760065] end rc.local: ciena_time 1380819089
rc_local_end=`evt_show | grep 'end rc.local' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`

echo "rc.local time:" $[rc_local_end-rc_local_start]

# 00000323 2013.10.03 16:51:00 SYSLOG NOTICE console: rc.local   start POST: ciena_time [ 1380819060 ]
post_start=`evt_show | grep 'start POST' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`
# 00000346 2013.10.03 16:51:25 SYSLOG NOTICE console: rc.local   end POST: ciena_time [ 1380819085 ]
post_end=`evt_show | grep 'end POST' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`

echo "POST time:" $[post_end-post_start]

# 00000347 2013.10.03 16:51:25 SYSLOG NOTICE console: rc.local   SAOS start: ciena_time [ 1380819085 ]
saos_start=`evt_show | grep 'SAOS start' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`

# 00000353 2013.10.03 16:51:29 SYSLOG NOTICE console: rc.local   SAOS ack: ciena_time [ 1380819089 ]
saos_end=`evt_show | grep 'SAOS ack' | grep -o "\[ *[0-9]*" | grep -o "[0-9]*"`

echo "SAOS app elapsed start time:" $[saos_end-saos_start]

echo "sysinit time:" $[rc_local_end-pid_1]

# get SAOS init
# 00000382 2013.10.03 16:51:40 init: ciena_time [76.446901927] {1380819100}
saos_init=`evt_show | grep 'init: ciena_time' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS SETUP-1
# 00000410 2013.10.03 16:52:00 setup-1: ciena_time [96.676186789] {1380819120}
saos_setup_one=`evt_show | grep 'setup-1' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS SETUP-2
# 00000416 2013.10.03 16:52:00 setup-2: ciena_time [96.821057840] {1380819120}
saos_setup_two=`evt_show | grep 'setup-2' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS POST
# 00000419 2013.10.03 16:52:02 post: ciena_time [98.724053784] {1380819122}
saos_post=`evt_show | grep 'post:' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS config read
# 00000420 2013.10.03 16:52:03 start config load: ciena_time [99.739287567] {1380819123}
saos_config=`evt_show | grep 'start config' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS config complete
# 00000421 2013.10.03 16:52:03 end config load: ciena_time [99.750711514] {1380819123}
saos_config_complete=`evt_show | grep 'end config' | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS RUN
# 00000424 2013.10.03 16:52:04 run: ciena_time [100.725612850] {1380819124}
saos_run=`evt_show | grep run: | grep -o "\[ *[0-9]*\." | grep -o "[0-9]*"`

# get SAOS traffic
# 00000438 2013.10.03 16:52:11 traffic: ciena_time [107.445451010] {1380819131}
saos_traffic=`evt_show | grep 'traffic' | grep -om 1 "{ *[0-9]*" | grep -o "[0-9]*"`
traffic_final=$[saos_traffic-diff_time]

echo
echo "SAOS application in seconds"
echo "---------------------------"
echo "run-mode INIT:" $[saos_setup_one-saos_init]
echo "run-mode SETUP-1:" $[saos_setup_two-saos_setup_one]
echo "run-mode SETUP-2:" $[saos_post-saos_setup_two]
echo "run-mode POST:" $[saos_config-saos_post]
echo "config:" $[saos_config_complete-saos_config]

if test $traffic_final -lt 0 
then
echo "run-mode RUN:" $saos_run
echo "traffic: N/A"
else
echo "run-mode RUN:" $[traffic_final-saos_run]
echo "traffic: " $traffic_final
fi

echo
echo
echo "RAW TIMES"
echo "---------"
echo "U-boot start:" $uboot_start
echo "U-boot mount fs:" $uboot_mount
echo "U-boot fpga load:" $uboot_fpga
echo "U-boot kernel hand-off:" $uboot_kernel
echo "Kernel init complete:" $kernel_mount
echo "Kernel mount complete:" $kernel_mount_end
echo "Kernel hand-off to Pid 1:" $pid_1
echo "rcS start:" $rc_start
echo "rc.local start:" $rc_local_start
echo "POST start:" $post_start
echo "POST end:" $post_end
echo "SAOS app start:" $saos_start
echo "SAOS app ack:" $saos_end
echo "rc.local end:" $rc_local_end
echo "rcS complete:" $rc_end_temp
echo "SAOS run-mode init:" $saos_init
echo "SAOS run-mode SETUP-1:" $saos_setup_one
echo "SAOS run-mode SETUP-2:" $saos_setup_two
echo "SAOS rum-mode POST:" $saos_post
echo "SAOS config load:" $saos_config
echo "SAOS config complete:" $saos_run
if test $traffic_final -lt 0
then
echo "SAOS traffic start: N/A"
else
echo "SAOS traffic start:" $traffic_final
fi
