#!/bin/sh
#########################################################################
#									#
# Name		: startNTP.sh						#
# Purpose	: Start NTP daemon					#
#									#
# Usage		:							#
#									#
# startNTP.sh [ <mode> [ <debug_level> [ <delay> ]]]			#
#									#
# where,								#
#									#
# <mode>	: polling | broadcast | multicast			#
# <debug_level>	: Internal NTP debug level flag, 0 == off		#
# <delay>	: * Number of seconds to start the NTP daemon *		#
#									#
#########################################################################

# Ignore SIGINT
# trap "" SIGINT

# Local declarations
ntp_status=0
ntp_mode=polling
ntp_debug=0
ntp_delay=2

[ "$#" -gt "0" ] && ntp_mode=$1
[ "$#" -gt "1" ] && ntp_debug=$2
[ "$#" -gt "2" ] && ntp_delay=$3

# Make sure NTPD is not running
/ciena/scripts/stopNTP.sh

# Only specify the "-b" option for
# "broadcast" mode.
if [ $ntp_mode = "broadcast" ]; then
    OPTS="-g -b"
else
    OPTS="-g"
fi 

PIDF=/var/run/ntpd.pid
OPTS="$OPTS -p $PIDF"

# Start the NTP daemon
if [ $ntp_debug = "0" ]; then
    /usr/sbin/ntpd $OPTS
else
    (/usr/sbin/ntpd $OPTS -D $ntp_debug </dev/null 2>&1 \
	| leos -L 10000/5 -l /tmp/log/ntpLog  >/dev/null 2>&1 \
	; rm -f $PIDF) &
fi

# Check the NTP daemon status
[ "$?" -ne "0" ] && ntp_status=2

# Wait for that number of seconds specified
sleep $ntp_delay

# Restore SIGINT
# trap - SIGINT

# Exit with status
exit $ntp_status

# End of startNTP.sh
