#!/bin/sh
#########################################################################
#									#
# Name		: stopSSH.sh						#
# Purpose	: Stop SSH daemon					#
#									#
# Usage		:							#
#									#
# stopSSH.sh								#
#									#
#########################################################################

SSHD_PID_FILE=/var/run/sshd.pid
sshdpid=

#Check if the PID file exists
if [ -e "$SSHD_PID_FILE" ]; then
    read sshdpid < $SSHD_PID_FILE
else
    #we return ok since we want to stop ssh, if
    #it's not running then be quiet and collect
    #the paycheck
    exit 0
fi

# Stop the SSH daemon
kill -9 $sshdpid

#Remove the SSH daemon PID file
[ "$?" -eq "0" ] && rm -f "$SSHD_PID_FILE"

# Exit with status 
exit 0

# End of stopSSH.sh
