#!/bin/sh
#########################################################################
#                                                                       #
# Name      : startNetconfd.sh                                          #
# Purpose   : Start netconfd daemon                                     #
#                                                                       #
# Usage     : startNetconfd.sh [debug] [netconfd-pro args]              #
#                                                                       #
#########################################################################

# Ignore SIGINT

# Local declarations
status=0
debug=0

                                        
# Check for 'debug' arg
if [ "$1" == "debug" ]
then
    debug=1
    shift
fi



# Make sure netconfd is not running
   /ciena/scripts/stopNetconfd.sh
   sleep 1

# Start the netconfd daemon, not as a real-time process (our parent LEOS is RT).
   export HOME=/tmp
#   export YUMAPRO_HOME=/tmp
   export YUMAPRO_MODPATH=/ciena/yang
   export YUMAPRO_RUNPATH=/usr/lib32:/usr/lib
   export LD_LIBRARY_PATH=/usr/lib32:/usr/lib
   if [ $debug == 1 ]
   then
      chrt -o 0 /usr/sbin/netconfd-pro --config=/ciena/scripts/netconfd.conf $* &
   else
      chrt -o 0 /usr/sbin/netconfd-pro --config=/ciena/scripts/netconfd.conf $* >/dev/null 2>&1 &
   fi
   status=$?

# Check the SSH daemon status
   if [ "$status" -ne "0" ]; then
      echo "$status:  Can't start netconfd"
      status=2
      exit $status
   fi

   sleep 5
   cp -f $HOME/.yumapro/netconfd-pro.pid /tmp/netconfdPid

# Exit with status

exit $status

# End of startNetconfd.sh
