#
# bash PATH manipulation functions
#
# These functions are intended to avoid adding the same item to the PATH
# multiple times.
#

#
# "source" this file to pick up the functions defined below.
#

path_append()  { path_remove $1; PATH="$PATH:$1"; }

path_prepend() { path_remove $1; PATH="$1:$PATH"; }

path_remove() {
    local p d
    p=":$1:"      # PATH component to remove
    d=":$PATH:"   # (scratch value) current PATH with colons stuck on both ends
    d=${d//$p/:}  # remove target component and its trailing colon
    d=${d/#:/}    # remove leading colon from the scratch PATH
    PATH=${d/%:/} # remove trailing colon and put the result back into PATH
}
