#!/bin/sh
#########################################################################
#									#
# Name		: sshKeyGen.sh						#
# Purpose	: Generate the SSH Keys (private and public)            #
#									#
# Usage		:							#
#									#
#									#
#########################################################################

keyTypeOptions=

# Delete the SSH Keys if they are present
if [ -f /mnt/sysfs/ssh/ssh_host_key ]; then
    rm -f /mnt/sysfs/ssh/ssh_host_key
fi
if [ -f /mnt/sysfs/ssh/ssh_host_key.pub ]; then
    rm -f /mnt/sysfs/ssh/ssh_host_key.pub
fi

case "$1" in
    "rsa2048")
        keyTypeOptions="-t rsa -b 2048"
        ;;
    "dsa1024")
        keyTypeOptions="-t dsa -b 1024"
        ;;
    "ecdsa256")
        keyTypeOptions="-t ecdsa -b 256"
        ;;
    "ecdsa384")
        keyTypeOptions="-t ecdsa -b 384"
        ;;
    "ecdsa521")
        keyTypeOptions="-t ecdsa -b 521"
        ;;
    *)
        # Should not occur
        exit 1
        ;;
esac

# Generate the keys now.  Make sure that even if we have a real-time
# parent that we make our slow self non-real-time and very nice...
chrt -o 0 nice /usr/bin/ssh-keygen -q $keyTypeOptions -N "" -f /mnt/sysfs/ssh/ssh_host_key > /dev/null 2>&1

# Exit with status 
exit 0

# End of sshKeyGen.sh
