#!/bin/sh
#########################################################################
#									#
# Name		: startTFTPD_for_PWE.sh					#
# Purpose	: Start TFTPD daemon for PWE supported platforms only	#
#									#
# Usage		:							#
#									#
# startTFTPD_for_PWE.sh						        #
#									#
#########################################################################

EXIT_SUCCESS=0
EXIT_COMMAND_FAILED=2

SYSLOG_ERR="logger -p USER.ERR  -t $(basename $0)"

# Make sure TFTPD is not running
/ciena/scripts/stopTFTPD.sh

# Start the TFTPD daemon

adduser -H -D -G root pwe
if [ "$?" -ne "0" ] ; then
   $SYSLOG_ERR "Failed to create user pwe! Aborting."
   exit $EXIT_COMMAND_FAILED
fi

in.tftpd -l -v -u pwe -c -a 169.254.1.1:69 &
if [ "$?" -ne "0" ] ; then
   $SYSLOG_ERR "Failed to initiate in.tftpd!"
   exit $EXIT_COMMAND_FAILED
fi

exit $EXIT_SUCCESS

# End of startTFTPD_for_PWE.sh
