#!/bin/bash

# This script will fix all of the USB partitions.  If there
# are multiple partitions this will delete them, and create
# only one partition

# Global variables
DEVICE=$2

# Returns the number of partitions on the device
function countPartitions {
    # Write any pending changes
    OUT=`echo -e "w\n" | fdisk /dev/$DEVICE > /dev/null`
    echo $OUT
    
    # This finds out how many partitions we have
    OUT=`fdisk /dev/$DEVICE -l | grep $DEVICE[[:digit:]] -c`
    echo $OUT
}

function removeAllPartitions {
    # Write any pending changes
    OUT=`echo -e "w\n" | fdisk /dev/$DEVICE > /dev/null`
    echo $OUT
    
    NP=`countPartitions`
    echo $NP
    for (( I=$NP; I>=1; I--))
    do
        `echo -e "d\n$I\nw\n"| fdisk /dev/$DEVICE > /dev/null`
    done
}

# This function only work with no partitions available
function createPartition {
    # Write any pending changes
    OUT=`echo -e "w\n" | fdisk /dev/$DEVICE > /dev/null`
    echo $OUT
    
    `echo -e "n\np\n1\n\n\nw\n"| fdisk /dev/$DEVICE > /dev/null`
}

# We want the number of partitions
if [ "$1" == "--num-partitions" ] ; then
    NP=`countPartitions`
    exit $NP
fi

# fix the partitions
if [ "$1" == "--fix-partitions" ] ; then
    # Remove all partitions (if any)
    removeAllPartitions
    # Create the new partitions
    createPartition
    exit 0
fi

exit 1