#!/bin/sh

# Script to create a hardening config file that represents the set of
# configuration changes during normal mode to achieve enhanced security mode.
# Is given the system type and number of ports as arguments.
# Is expected to emit (on stdout) a valid configuration file.

device_name=$1
num_ports=$2


echo "! Enhanced Security Configuration"
echo "! Device Name: $1"
echo "! Max Ports: $2"
echo "!"

# turn off zero touch
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! turn off zero touch"
echo "dhcp client disable"
echo "dhcpv6 client disable"
echo "!"

# delete the remote interface
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! delete the remote interface"
# this appears to not be possible in the CLI so we'll disable instead
echo "interface remote disable"
echo "!"

# adjust IP stack settings
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! adjust ip stack settings"
echo "interface ipv4-stack set icmp-accept-redirects off"
echo "interface ipv6-stack set icmp-accept-redirects off"
echo "interface ipv4-stack set icmp-echo-ignore-broadcasts on"
echo "interface ipv6-stack set icmp-echo-ignore-broadcasts on"
echo "!"

# remove all the  ports from VLAN 1 based on the platform type
# first put all the ports into VLAN 127 if they're not already in vlan 127
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! Remove all the  ports from VLAN 1 based on the platform type"

case $device_name in
# Dernhelm Platforms
    "3902" | "3903")    echo "vlan add vlan 127 port 1" ;;
    "3904" | "3905")    echo "vlan add vlan 127 port 1,2" ;;

# Caliondo Platforms
    "3916" )    echo "vlan add vlan 127 port 1,2" ;;

    "3930" | "3931" | "3932")   echo "vlan add vlan 127 port 1-8" ;;

    "3938" )    echo "vlan add vlan 127 port 1-16, 21-24" ;;

    "3942" )    echo "vlan add vlan 127 port 1-20"  ;;

# all ports on these platforms are already in VLAN 127
#    "5142" | "5150" | "5160" ) ;;

# Brego Platforms
    "3960" | "CN3960" | "CN 3960")    echo "vlan add vlan 127 port 1-8" ;;
esac

# Now remove all the ports from VLAN 1 - some platforms are special cased
case $device_name in
    "5150" | "CN5150" | "CN 5150")  echo "vlan remove vlan 1 port 2.1,2.2,3.1,3.2"
             echo "vlan remove vlan 1 port 1.1-1.48" ;;

    * ) echo "vlan remove vlan 1 port 1-$num_ports" ;;
esac

echo "!"
# Delete vlan 1
# VLAN 1 can't actually be deleted, it is the default vlan where ports are
# automatically located when they are otherwise removed from all other vlans.
#echo "vlan delete vlan 1"
#echo "!"

# delete the default user accounts
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! Delete the default user accounts"
echo "user delete user user"
echo "user delete user admin"
echo "user delete user gss"
echo "!"

# set the ssh daemon config settings
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! Set the ssh daemon config settings"
echo "ssh server set max-shared-sessions 1"
echo "ssh server set strict-mode on"
echo "ssh server set tcp-forwarding off"
echo "ssh server set tcp-keepalive off"
echo "ssh server set rekey-limit 1G"
echo "ssh server set rekey-timeout 1h"
echo "ssh server set fips-mode on"
echo "ssh server set client-alive-interval 60"
echo "ssh server set client-alive-count 0"
echo "!"

# turn off unneeded servers
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! Turn off unneeded servers"
echo "telnet server disable"
echo "system server sftp disable"
echo "!"


# delete the default SNMP communities
echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
echo "! Delete the default SNMP communities"
echo "snmp delete community-index t0000000"
echo "snmp delete community-index t0000001"
echo "!"

# turn off everything so that it can be explicitly enabled

exit 0
