#!/usr/bin/awk -f

#	mfg power eeread 1 0 256
#	mfg power eeread 2 0 256
#	i2c_generic_rdwr /dev/i2c-58 0x50  0  -r 256
#	i2c_generic_rdwr /dev/i2c-59 0x51  0  -r 256
#	i2c_generic_rdwr /dev/i2c-12 0x50  0  -r 256  # 3931 ps 1
#	i2c_generic_rdwr /dev/i2c-13 0x51  0  -r 256  # 3931 ps 2

function calc_checksum(cmd, size,	rd_cmd,sum,i,r,k) {
	rd_cmd = cmd " 0 -r 256"
	sum = 0
	i = 0
	$0 = ""
	for (r = 0; r < 16; r++) {

		rd_cmd | getline

		if ( ! length($0) ) { return -1 }

		print

		for (k = 2; k < 18 && i < size; k++, i++) {
			sum += int("0x"$k)
		}
	}
	close(rd_cmd)
	return sum
}

function read_checksum(cmd,	rd_cmd) {
	rd_cmd = cmd " 184 -r 2"
	print rd_cmd
	$0 = ""
	rd_cmd | getline
	close(rd_cmd)
	if ( ! length($0) ) { return -1 }
	return int("0x"$4)
}

function write_checksum(cmd, value,	wr_cmd) {
	wr_cmd = cmd " 184 -s " value
	print wr_cmd
	$0 = ""
	wr_cmd | getline
	close(wr_cmd)
}

function fix_rev_field(cmd, value,	xr_cmd) {
	xr_cmd = cmd " 0x24 -s " value
	print xr_cmd
	$0 = ""
	xr_cmd | getline
	close(xr_cmd)

	system("sleep 1")
}

function last_two_digits(num) {
	num = sprintf("%02x", num)
	return substr(num, length(num)-2+1)
}

function check_eeprom(cmd,	sum,old,new) {
#	fix_rev_field(cmd, "004")

	sum = calc_checksum(cmd, 174)
	printf "calculated checksum %d 0x%x\n", sum, sum
	if (sum >= 0) {
		old = read_checksum(cmd)
		printf "old checksum %x\n", old

		sum = last_two_digits(sum)
		old = last_two_digits(old)

		if (old == sum) {
			print "---------- okay", old, "matches", sum, "----------"
		} else {
			print "***", old, "does not match expected", sum, "***"
			write_checksum(cmd, sum)

			system("sleep 1")

			new = read_checksum(cmd)
			printf "new checksum %x\n", new
			new = last_two_digits(new)
			if (new == sum) {
				print "---------- okay", new, "matches", sum, "----------"
			} else {
				print "********** FAIL", new, "matches", sum, "**********"
			}
		}
	}
}

BEGIN {
	for (i = 0; i < ARGC; i++) {
		# print ARGV[i]
		delete ARGV[i]
	}

	eeprom1 = "i2c_generic_rdwr /dev/i2c-12 0x50 "
	eeprom2 = "i2c_generic_rdwr /dev/i2c-13 0x51 "

	print "power supply 1 (top)"
	check_eeprom(eeprom1)

	print "power supply 2 (bottom)"
	check_eeprom(eeprom2)
}

