#!/bin/bash

source /ciena/scripts/utils.sh
fpgapath='/ciena/fpga'
debug_fpgapath='/mnt/sysfs/fpga'
loader=/ciena/bin/fpgadownload
zcat=/usr/bin/zcat

load_fpga ()
{
    local board_id="$1"
    local filename="$2"

    if [ "$filename" = "${filename##*/}" ]  # filename without path
    then
        if [ -r "$debug_fpgapath/$filename" ]
        then
            filename="$debug_fpgapath/$filename"
        elif [ -r "$debug_fpgapath/${filename%.gz}" ]
        then
            filename="$debug_fpgapath/${filename%.gz}"
        else
            filename="$fpgapath/$filename"
        fi
    fi

    if [ -r "$filename" ]
    then
        echo loading FPGA with $filename
        if [ "${filename##*.}" = 'gz' ]
        then
            if [ $(get_board_name) == '5150' ]; then
                $loader "$board_id" "$filename"    # 5150 filename will be replaced in call
            else
                $zcat "$filename" | $loader "$board_id" -
            fi
        else
            $loader "$board_id" "$filename"
        fi

        # for boards using shared irq driver for datapath FPGA load the driver
        # here to allow access to the FPGA version info.
        insmod_uio_ciena_pdrv_shared_irq

        if [ $? -eq 0 ]
        then
            show_fpga_version
        else
            echo $0: $filename: loading FPGA failed
        fi
    else
        echo $0: $filename: No such file
    fi
}

load_fpga_setup
id=$(get_board_id)
fpgafilename=$(get_data_fpga_file)
load_fpga "$id" "$fpgafilename"
