#!/bin/bash

#-------------------------------------------------------------------------------
# INPUT / FORWARD
# * DROP all ARP  packets with dst IP NOT in our subnets
# * DROP all IPv6 packets
#

#-------------------------------------------------------------------------------
# Open the INPUT/FORWARD chain to prevent communications hits while the rules are
# being updated. 
ebtables -P INPUT ACCEPT
ebtables -P FORWARD ACCEPT

# Flush the current rules.
ebtables -F
ebtables -X

#-------------------------------------------------------------------------------
# Setup the FORWARD and INPUT chains.
# Prevent dst IPv4 address not included in the subnet
ebtables -A FORWARD -p arp --arp-ip-dst ! $1 -i local.vlan -j DROP
ebtables -A INPUT -p arp --arp-ip-dst ! $1 -i local.vlan -j DROP      

# Prevent IPv6
ebtables -A FORWARD -p ipv6 -j DROP
ebtables -A INPUT -p ipv6  -j DROP
ebtables -A OUTPUT -p ipv6  -j DROP

exit 0
