<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template name="render-object">
        <xsl:param name="obj">x.</xsl:param>
        <xsl:param name="parent"></xsl:param>

        <xsl:if test="$parent = '' ">
            <tr bgcolor="#CCCCCC">
                <td colspan="6" align="center">
                    <b>
                        <xsl:value-of select="@name"/>
                    </b>
                </td>
            </tr>
        </xsl:if>

       <xsl:variable name="prior" select="@name"/>
        <xsl:for-each select="object">
            <xsl:call-template name="render-object">
                <xsl:with-param name="obj" select="."/>
                <xsl:with-param name="parent" select="$prior"/>
            </xsl:call-template>

        </xsl:for-each>

        <xsl:for-each select="unixcommand">
            <tr>
                <td align="center">
                        <xsl:value-of select="@name"/>
                </td>
                <td></td>
                <td align="center">
                    <xsl:value-of select="@arguments"/>
                </td>
                <td align="center">
                    <xsl:value-of select="@access"/>
                </td>
                <td align="center">
                    <xsl:value-of select="@descr"/>
                </td>
                <td align="center">
                    <xsl:value-of select="@docDescr"/>
                </td>
            </tr>
        </xsl:for-each>

        <xsl:for-each select="command">
            <tr>
                <td align="center">
                        <xsl:if test="$parent != '' ">
                            <xsl:value-of select="$prior"/><xsl:text> </xsl:text>
                        </xsl:if>
                        <xsl:value-of select="action/@name"/>
                </td>
                <td></td>
                <td></td>
                <td align="center">
                    <xsl:value-of select="action/@access"/>
                </td>
                <td align="center">
                    <xsl:value-of select="action/@descr"/>
                </td>
                <td align="center">
                    <xsl:value-of select="action/@docDescr"/>
                </td>
            </tr>

            <xsl:if test="instance">
                <xsl:for-each select="instance">
                    <tr>
                        <td></td>
                        <td></td>
                        <td align="center">
                            <font color="#FF00FF">
                                <xsl:value-of select="@type"/>
                            </font>
                        </td>
                        <td></td>
                        <td align="center">
                            <font color="#FF00FF">
                                <xsl:value-of select="@descr"/>
                            </font>
                        </td>
                        <td align="center">
                            <font color="#FF00FF">
                                <xsl:value-of select="@docDescr"/>
                            </font>
                        </td>
    
                    </tr>
                </xsl:for-each>
            </xsl:if>

            <xsl:if test="attributes">
                <xsl:for-each select="attributes/attribute">
                        <tr>
                            <td></td>
                            <td align="center">
                                <font color="#0000FF">
                                    <xsl:value-of select="@name"/>
                                </font>
                            </td>
                            <td align="center">
                                <font color="#0000FF">
                                    <xsl:value-of select="@type"/>
                                    <xsl:if test="@type='xml-string' ">
                                        <xsl:choose>
                                            <xsl:when test="@maxLength">
                                                <xsl:text>[</xsl:text>
                                                <xsl:value-of select="@maxLength"/>
                                                <xsl:text>]</xsl:text>
                                            </xsl:when>
                                            <xsl:when test="stringval">
                                                <xsl:text>[</xsl:text>
                                                <xsl:for-each select="stringval">
                                                    <xsl:value-of select="."/>
                                                    <xsl:text> </xsl:text>
                                                </xsl:for-each>
                                                <xsl:text>]</xsl:text>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:text>[ERROR IN FILE]</xsl:text>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                    </xsl:if>
                                    <xsl:if test="@type='xml-integer' or @type='xml-uinteger' ">
                                        <xsl:text>[</xsl:text>
                                        <xsl:if test="@minValue">
                                            <xsl:value-of select="@minValue"/>
                                        </xsl:if>
                                        <xsl:text>..</xsl:text>
                                        <xsl:if test="@maxValue">
                                            <xsl:value-of select="@maxValue"/>
                                        </xsl:if>
                                        <xsl:text>]</xsl:text>
                                    </xsl:if>
                                </font>
                            </td>
                            <td align="center">
                                <font color="#FF00FF">
                                    <xsl:value-of select="@access"/>
                                </font>
                            </td>
                            <td align="center">
                                <font color="#FF00FF">
                                    <xsl:value-of select="@descr"/>
                                </font>
                            </td>
                            <td align="center">
                                <font color="#FF00FF">
                                    <xsl:value-of select="instance/@docDescr"/>
                                </font>
                            </td>
                        </tr>
                </xsl:for-each>
            </xsl:if>


        </xsl:for-each>

    </xsl:template>

    <xsl:template match="/">
        <html>
            <head>
                <STYLE TYPE="text/css">
                  body {
                    font-family: Trebuchet MS, Arial, Helvetica, sans-serif;
                    background: #ffffff;
                    font-size: 12px;
                    }
                  table { 
                	font-size: 12px;
                	border-collapse:collapse;	
                        color:#000; 
                	}
                  tr th, tr td {
                        border-bottom:1px 
                        solid #eee;
                        }
                 </STYLE>
            </head>
            <body>
                <h2 align="center">LE-OS CLI Commands</h2>
                <h1>Key</h1>
                <p>
    action
                </p>
                <p>
                    <font color="#FF00FF">Instance info</font>
                </p>
                <p>
                    <font color="#0000FF">Attribute info</font>
                </p>
                <center>
                    <table border="1">
                        <tr>
                            <th align="center">Action</th>
                            <th align="center">Keyword</th>
                            <th align="center">Type</th>
                            <th align="center">Security Level</th>
                            <th align="center">User Description</th>
                            <th align="center">Doc Description</th>
                        </tr>

                <xsl:for-each select="cli/object">
                    <xsl:call-template name="render-object">
                        <xsl:with-param name="obj">cli/object</xsl:with-param>
                    </xsl:call-template>
                </xsl:for-each>

                    </table>

                </center>

            </body>
        </html>
    </xsl:template>


</xsl:stylesheet>
