# awk program to parse fields from proc/<pid>/smaps.
#
# Output is in the following form (space separated fields):
# start-addr end-addr mode name size rss
#


/^[0-9a-f]+-[0-9a-f]+/ {
  split($1,range,"-");
  printf("%s %s %s ", range[1], range[2], $2);
  if (length($6) == 0)
    printf("<anon> ");
  else
    printf("%s ", $6);
}

/^Size:/ {
  printf("%d ", $2);
}

/^Rss:/ {
  printf("%d\n", $2);
}
