#!/bin/sh
### BEGIN INIT INFO
# Provides:           mtdoops
# Short-Description:  Collect the mtdoops panic logs.
### END INIT INFO

MTDOOPS_DIR="/dev/mtd"
MTDOOPS_ARCH_DIR="/mnt/log/panic"
MTDOOPS_VALID_SLOT="0x5d005d00"
MTDOOPS_KEEP_COUNT=8
MTDOOPS_RECORD_SIZE="0x00010000"

# -----------------------------------------------------------------------------
create_fault_log() {
    # Make sure the fault directory exists with appropriate permissions
    if [ ! -d ${MTDOOPS_ARCH_DIR} ]; then
        mkdir -p ${MTDOOPS_ARCH_DIR}
        chmod 0775 ${MTDOOPS_ARCH_DIR}
    fi
}

# -----------------------------------------------------------------------------
# check if a new kernel panic log is present
kernel_new_paniclog_present()
{
    [ $(( ${2} )) -eq $(( ${MTDOOPS_VALID_SLOT} )) ] && \
        [ ! -f ${MTDOOPS_ARCH_DIR}/paniclog-$(( ${1} ))-* ]
}

#------------------------------------------------------------------------------
# move new kernel panic log files to ${MTDOOPS_ARCH_DIR}
handle_kernel_paniclog_mtdoops()
{
    local _slot _seq _check _size _mtdsize
    local -a _hdr

    if [ ! -r ${MTDOOPS_DIR}/paniclog0 ]; then
       echo "MTD oops partitions not present"
    return 0
    fi

    create_fault_log
    _size=( $(cat /proc/mtd|grep paniclog0|cut -d " " -f 2) )
    _mtdsize=0x${_size}

    for _slot in ${MTDOOPS_DIR}/paniclog[0-9]*; do

        _hdr=( $(dd if=${_slot} bs=4 count=2 2>/dev/null | od -X) )
        _seq=0x${_hdr[1]}
        _check=0x${_hdr[2]}

        if kernel_new_paniclog_present ${_seq} ${_check}; then

            cat ${_slot} | \
                dd bs=4 skip=2 2>/dev/null | \
                tr -s '\377' '\n' > \
                ${MTDOOPS_ARCH_DIR}/paniclog-$(( ${_seq} ))-$(date +%s)

        fi

        if [ $(( ${_mtdsize} )) -eq $(( 2*${MTDOOPS_RECORD_SIZE} )) ]; then

                _hdr=( $(dd if=${_slot} bs=4 count=2 skip=16384 2>/dev/null | od -X) )
                _seq=0x${_hdr[1]}
                _check=0x${_hdr[2]}

                if kernel_new_paniclog_present ${_seq} ${_check}; then
                                                                                      
                        cat ${_slot} | \
                        dd bs=4 skip=16386 2>/dev/null | \
                        tr -s '\377' '\n' > \
                        ${MTDOOPS_ARCH_DIR}/paniclog-$(( ${_seq} ))-$(date +%s)
                                                                                      
                fi
        fi
    done

    # keep only the most recent archives
    ls -1t ${MTDOOPS_ARCH_DIR}/paniclog-* 2>/dev/null \
        | awk -vKEEP=${MTDOOPS_KEEP_COUNT} 'NR>KEEP' \
        | xargs -r rm -f
}
