/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.Component;
import cisco.dsbu.cms.boot.internal.Distribution;
import cisco.dsbu.cms.boot.internal.SgzReader;
import cisco.dsbu.cms.boot.internal.VersionXml;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import cisco.dsbu.cms.boot.internal.xmllite.Parser;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class Package
implements Handler,
VersionXml {
    private static final boolean DEBUG = true;
    private static final byte NOT_LOADED = 0;
    private static final byte LOADING = 1;
    private static final byte LOADED = 2;
    private Distribution container;
    private String name;
    private String extension;
    private int size;
    private List components;
    private CharString currElem;
    private byte loadState;
    private int numLatest;

    Package(Distribution distribution) {
        this.container = distribution;
        this.loadState = 0;
    }

    URL getFilesystem() {
        return this.container.getFilesystem();
    }

    public String toString() {
        return this.name + "." + this.extension;
    }

    List getComponents() {
        return this.components;
    }

    void updateNumLatest(boolean bl) {
        this.numLatest = bl ? ++this.numLatest : --this.numLatest;
        this.container.updateNumLatest(bl);
    }

    void load() {
        Package package_ = this;
        synchronized (package_) {
            if (this.loadState != 0) {
                return;
            }
            this.loadState = 1;
        }
        this.loadPackage();
        Package package_2 = this;
        synchronized (package_2) {
            this.loadState = (byte)2;
        }
    }

    private void loadPackage() {
        if (this.extension == null || this.extension.equals("")) {
            this.loadUnpackaged();
        } else if (this.extension.equals("sgz")) {
            this.loadSgzPackage();
        } else {
            System.out.println("Unknown extension; ignoring " + this.name + '.' + this.extension);
        }
    }

    private void getContents(InputStream inputStream, byte[] byArray) throws IOException {
        int n = 0;
        while (inputStream.available() > 0) {
            try {
                int n2 = inputStream.read(byArray, n, byArray.length - n);
                if (n2 <= 0) break;
                n += n2;
            }
            catch (EOFException eOFException) {
                break;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void loadUnpackaged() {
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!component.isLatest()) continue;
            InputStream inputStream = null;
            URL uRL = new URL(this.getFilesystem(), component.getName());
            inputStream = uRL.openStream();
            byte[] byArray = new byte[component.getSize()];
            this.getContents(inputStream, byArray);
            component.setSigned(true);
            component.setContents(byArray);
            Object var7_8 = null;
            try {
                if (inputStream == null) continue;
                inputStream.close();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
            }
            continue;
            {
                catch (MalformedURLException malformedURLException) {
                    component.setContentsNotFound();
                    malformedURLException.printStackTrace();
                    var7_8 = null;
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    continue;
                }
                catch (IOException iOException) {
                    component.setContentsNotFound();
                    iOException.printStackTrace();
                    var7_8 = null;
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException2) {
                        iOException2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var7_8 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSgzPackage() {
        try {
            var1_1 = new URL(this.getFilesystem(), this.name + "." + this.extension);
        }
        catch (MalformedURLException var2_2) {
            var2_2.printStackTrace();
            return;
        }
        System.out.println("Loading package: " + var1_1);
        var2_3 = null;
        var3_4 = null;
        try {
            var2_3 = var1_1.openStream();
            var3_4 = new SgzReader(var2_3);
            var6_5 = this.components.iterator();
            while (var6_5.hasNext()) {
                var7_9 = (Component)var6_5.next();
                if (!var7_9.isLatest()) continue;
                var4_6 = var7_9.getName();
                do {
                    if ((var5_8 = var3_4.getNextElement()) != null) continue;
                    this.markContentsNotFound(var7_9, var6_5);
                    var11_12 = null;
                    ** GOTO lbl62
                } while (!var5_8.equals(var4_6));
                var8_10 = var3_4.getElementStatus();
                if (var8_10 == 2) {
                    var7_9.setContentsNotFound();
                    continue;
                }
                var7_9.setSigned(var8_10 == 1);
                var9_11 = var3_4.getElementData();
                var7_9.setContents(var9_11);
            }
            ** GOTO lbl72
        }
        catch (IOException var4_7) {
            var4_7.printStackTrace();
            var11_14 = null;
            try {
                if (var3_4 != null) {
                    var3_4.close();
                    return;
                }
                if (var2_3 == null) return;
                var2_3.close();
                return;
            }
            catch (IOException var12_18) {
                var12_18.printStackTrace();
                return;
            }
        }
        {
            catch (Throwable var10_20) {
                var11_15 = null;
                ** try [egrp 3[TRYBLOCK] [3 : 264->286)] { 
lbl53:
                // 1 sources

                if (var3_4 != null) {
                    var3_4.close();
                    throw var10_20;
                }
                if (var2_3 == null) throw var10_20;
                var2_3.close();
                throw var10_20;
lbl59:
                // 1 sources

                catch (IOException var12_19) {
                    var12_19.printStackTrace();
                }
                throw var10_20;
            }
lbl62:
            // 1 sources

            ** try [egrp 3[TRYBLOCK] [3 : 264->286)] { 
lbl63:
            // 1 sources

            if (var3_4 != null) {
                var3_4.close();
                return;
            }
            if (var2_3 == null) return;
            var2_3.close();
            return;
lbl69:
            // 1 sources

            catch (IOException var12_16) {
                var12_16.printStackTrace();
            }
            return;
lbl72:
            // 1 sources

            var11_13 = null;
            try {}
            catch (IOException var12_17) {}
            var12_17.printStackTrace();
            return;
            if (var3_4 != null) {
                var3_4.close();
                return;
            }
            if (var2_3 == null) return;
            var2_3.close();
            return;
        }
    }

    private void markContentsNotFound(Component component, Iterator iterator) {
        component.setContentsNotFound();
        while (iterator.hasNext()) {
            Component component2 = (Component)iterator.next();
            component2.setContentsNotFound();
        }
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString charString) throws ParseException {
        this.currElem = null;
        if (charString.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (charString.equals(VersionXml.EXTENSION)) {
            this.currElem = VersionXml.EXTENSION;
        } else if (charString.equals(VersionXml.SIZE)) {
            this.currElem = VersionXml.SIZE;
        } else if (charString.equals(VersionXml.NUM_COMP)) {
            this.currElem = VersionXml.NUM_COMP;
        } else if (charString.equals(VersionXml.COMPONENT)) {
            this.currElem = VersionXml.COMPONENT;
            Component component = new Component(this);
            this.components.add(component);
            parser.pushHandler(component);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString charString) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = charString.toString();
        } else if (this.currElem == VersionXml.EXTENSION) {
            this.extension = charString.toString();
        } else if (this.currElem == VersionXml.SIZE) {
            this.size = charString.toInt();
        } else if (this.currElem == VersionXml.NUM_COMP) {
            this.components = new ArrayList(charString.toInt());
        }
    }

    public void endElement(Parser parser, CharString charString) throws ParseException {
        if (charString.equals(VersionXml.PACKAGE)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }
}

