/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.xmllite;

import cisco.dsbu.cms.boot.internal.xmllite.Buffer;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;

public class Parser {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private boolean isParsing;
    private Buffer buffer;
    private List handlers = new LinkedList();
    private List elements = new LinkedList();
    private int ignoreDepth = 0;

    public Parser() {
        this.buffer = new Buffer(8192);
    }

    public Parser(int n) {
        this.buffer = new Buffer(n);
    }

    public void setSource(Reader reader) throws IllegalStateException {
        this.throwExceptionIf(this.isParsing, "Parsing is already in progress.");
        this.buffer.setSource(reader);
    }

    public void pushHandler(Handler handler) {
        this.handlers.add(0, handler);
    }

    public Handler popHandler() {
        Handler handler = null;
        if (!this.handlers.isEmpty()) {
            handler = (Handler)this.handlers.remove(0);
        }
        return handler;
    }

    public void startParsing() throws IllegalStateException, IOException, ParseException {
        this.throwExceptionIf(this.isParsing, "Parsing is already in progress.");
        this.throwExceptionIf(this.handlers.isEmpty(), "A handler has not been set.");
        Handler handler = (Handler)this.handlers.get(0);
        this.isParsing = true;
        handler.startDocument(this);
        while (true) {
            try {
                char c = this.buffer.peek();
                if (c == '<') {
                    this.handleTagStart(handler);
                } else if (Character.isWhitespace(c)) {
                    this.handleWhiteSpace();
                } else {
                    this.handleElementData(handler);
                }
            }
            catch (EOFException eOFException) {
                break;
            }
            this.throwExceptionIf(this.handlers.isEmpty(), "A handler has not been set.");
            handler = (Handler)this.handlers.get(0);
        }
        if (!this.elements.isEmpty()) {
            throw new ParseException(this, "Unexpected end-of-document");
        }
        handler.endDocument(this);
        this.isParsing = false;
    }

    private void handleTagStart(Handler handler) throws IOException, ParseException {
        this.buffer.readCharacter();
        char c = this.buffer.peek();
        if (c == '?' || c == '!') {
            this.handleIgnore();
        } else if (c == '/') {
            this.handleEndElement(handler);
        } else {
            if (Character.isWhitespace(c)) {
                throw new ParseException(this, "White space is not allowed after <");
            }
            this.handleStartElement(handler);
        }
    }

    private void handleWhiteSpace() throws IOException {
        int n;
        while ((n = this.buffer.findNonWhiteSpace()) == -1) {
            this.buffer.readCharacters();
        }
        this.buffer.readCharacters(n - 1);
    }

    private void handleElementData(Handler handler) throws IOException, ParseException {
        int n = this.buffer.find('<');
        if (n == -1) {
            throw new ParseException(this, "Element data exceeds buffer size.");
        }
        CharString charString = this.buffer.readCharacters(n - 1).trim();
        if (this.ignoreDepth == 0) {
            handler.elementData(this, charString);
        }
    }

    private void handleIgnore() throws IOException {
        int n;
        while ((n = this.buffer.find('>')) == -1) {
            this.buffer.readCharacters();
        }
        this.buffer.readCharacters(n);
    }

    private void handleEndElement(Handler handler) throws IOException, ParseException {
        this.buffer.readCharacter();
        int n = this.buffer.find('>');
        if (n == -1) {
            throw new ParseException(this, "End tag exceeds buffer size.");
        }
        CharString charString = this.buffer.readCharacters(n - 1).trim();
        if (this.ignoreDepth > 0) {
            CharString charString2 = (CharString)this.elements.get(0);
            if (charString.equals(charString2)) {
                this.elements.remove(0);
                --this.ignoreDepth;
            }
        } else {
            CharString charString3 = (CharString)this.elements.get(0);
            if (!charString.equals(charString3)) {
                throw new ParseException(this, charString3 + " closed by " + charString);
            }
            this.elements.remove(0);
            handler.endElement(this, charString);
        }
        this.buffer.readCharacter();
    }

    private void handleStartElement(Handler handler) throws IOException, ParseException {
        int n = this.buffer.find('>');
        if (n == -1) {
            throw new ParseException(this, "Start tag exceeds buffer size.");
        }
        CharString charString = this.buffer.readCharacters(n - 1).trim();
        if (this.ignoreDepth > 0) {
            CharString charString2 = (CharString)this.elements.get(0);
            if (charString.equals(charString2)) {
                this.elements.add(0, charString2);
                ++this.ignoreDepth;
            }
        } else {
            CharString charString3 = handler.startElement(this, charString);
            if (charString3 == null) {
                this.elements.add(0, new CharString(charString));
                ++this.ignoreDepth;
            } else {
                this.elements.add(0, charString3);
            }
        }
        this.buffer.readCharacter();
    }

    private void throwExceptionIf(boolean bl, String string) throws IllegalStateException {
        if (bl) {
            throw new IllegalStateException(string);
        }
    }
}

