/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Point;
import java.io.Serializable;
import javachart.chart.Chart;
import javachart.chart.Datum;
import javachart.chart.Transform;

public class DataTransform
implements Serializable {
    private Transform dataXfm;
    private Chart myChart;
    private double xAxisStart;
    private double xAxisEnd;
    private double yAxisStart;
    private double yAxisEnd;
    private int chartMaxX;
    private int chartMaxY;

    public DataTransform(Chart chart) {
        this.myChart = chart;
        this.buildTransform();
    }

    private void buildTransform() {
        this.xAxisStart = this.myChart.getXAxis().getAxisStart();
        this.xAxisEnd = this.myChart.getXAxis().getAxisEnd();
        this.yAxisStart = this.myChart.getYAxis().getAxisStart();
        this.yAxisEnd = this.myChart.getYAxis().getAxisEnd();
        this.chartMaxX = this.myChart.globals.maxX;
        this.chartMaxY = this.myChart.globals.maxY;
        this.dataXfm = new Transform(this.xAxisStart, this.yAxisStart, this.xAxisEnd, this.yAxisEnd, this.myChart.plotarea.transform.point(this.myChart.plotarea.llX, this.myChart.plotarea.llY), this.myChart.plotarea.transform.point(this.myChart.plotarea.urX, this.myChart.plotarea.urY));
        this.dataXfm.logXScaling = this.myChart.getXAxis().getLogScaling();
        this.dataXfm.logYScaling = this.myChart.getYAxis().getLogScaling();
    }

    private boolean checkDirty() {
        return this.xAxisStart != this.myChart.getXAxis().getAxisStart() || this.xAxisEnd != this.myChart.getXAxis().getAxisEnd() || this.yAxisStart != this.myChart.getYAxis().getAxisStart() || this.yAxisEnd != this.myChart.getYAxis().getAxisEnd() || this.chartMaxX != this.myChart.globals.maxX || this.chartMaxY != this.myChart.globals.maxY;
    }

    public Point datumToPoint(Datum datum) {
        if (this.checkDirty()) {
            this.buildTransform();
        }
        Point point = this.dataXfm.point(datum.x, datum.y);
        point.y = this.myChart.globals.maxY - point.y;
        return point;
    }

    public Datum pointToDatum(Point point) {
        if (this.checkDirty()) {
            this.buildTransform();
        }
        return new Datum(this.dataXfm.xValue(point.x), this.dataXfm.yValue(this.myChart.globals.maxY - point.y), this.myChart.globals);
    }

    public void resize() {
    }
}

