/*
 * Decompiled with CFR 0.152.
 */
package javachart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javachart.chart.Globals;

public class Gc
implements Serializable {
    Color markerColor;
    int markerStyle = 1;
    int markerSize = 1;
    Color fillColor;
    transient Image image;
    Globals globals;
    Color lineColor;
    int lineStyle = 1;
    int lineWidth = 1;
    public static Color TRANSPARENT = new Color(1, 1, 1);
    public static final int DEFAULT_FORMAT = 0;
    public static final int COMMA_FORMAT = 1;
    public static final int EURO_FORMAT = 2;
    static int individualCount;
    public static final int keepBELOW = 0;
    public static final int keepLEFT = 1;
    public static final int keepABOVE = 2;
    public static final int keepRIGHT = 3;
    public static Font defaultFont;

    static {
        defaultFont = new Font("TimesRoman", 0, 12);
    }

    public Gc(int n, Globals globals) {
        this.globals = globals;
        switch (n) {
            case 0: {
                this.assignColors(Color.blue);
                break;
            }
            case 1: {
                this.assignColors(Color.red);
                break;
            }
            case 2: {
                this.assignColors(Color.green);
                break;
            }
            case 3: {
                this.assignColors(Color.cyan);
                break;
            }
            case 4: {
                this.assignColors(Color.orange);
                break;
            }
            case 5: {
                this.assignColors(Color.pink);
                break;
            }
            case 6: {
                this.assignColors(Color.yellow);
                break;
            }
            case 7: {
                this.assignColors(Color.magenta);
                break;
            }
            case 8: {
                this.assignColors(Color.lightGray);
                break;
            }
            case 9: {
                this.assignColors(Color.darkGray);
                break;
            }
            case 10: {
                this.assignColors(Color.blue.darker());
                break;
            }
            case 11: {
                this.assignColors(Color.red.darker());
                break;
            }
            case 12: {
                this.assignColors(Color.green.darker());
                break;
            }
            case 13: {
                this.assignColors(Color.cyan.darker());
                break;
            }
            case 14: {
                this.assignColors(Color.orange.darker());
                break;
            }
            case 15: {
                this.assignColors(Color.pink.darker());
                break;
            }
            case 16: {
                this.assignColors(Color.yellow.darker());
                break;
            }
            case 17: {
                this.assignColors(Color.magenta.darker());
                break;
            }
            case 18: {
                this.assignColors(Color.lightGray.darker());
                break;
            }
            case 19: {
                this.assignColors(Color.darkGray.darker());
                break;
            }
            default: {
                this.assignColors(this.randomColor());
            }
        }
    }

    public Gc(Color color, Globals globals) {
        this.globals = globals;
        this.assignColors(color);
    }

    public Gc(Globals globals) {
        this.globals = globals;
        this.fillColor = Color.black;
        this.markerColor = Color.black;
        this.lineColor = Color.black;
    }

    public Gc(boolean bl, Globals globals) {
        this.globals = globals;
        if (!bl) {
            return;
        }
        switch (++individualCount) {
            case 0: {
                this.assignColors(Color.blue);
                break;
            }
            case 1: {
                this.assignColors(Color.red);
                break;
            }
            case 2: {
                this.assignColors(Color.green);
                break;
            }
            case 3: {
                this.assignColors(Color.cyan);
                break;
            }
            case 4: {
                this.assignColors(Color.orange);
                break;
            }
            case 5: {
                this.assignColors(Color.pink);
                break;
            }
            case 6: {
                this.assignColors(Color.yellow);
                break;
            }
            case 7: {
                this.assignColors(Color.magenta);
                break;
            }
            case 8: {
                this.assignColors(Color.lightGray);
                break;
            }
            case 9: {
                this.assignColors(Color.darkGray);
                break;
            }
            case 10: {
                this.assignColors(Color.blue.darker());
                break;
            }
            case 11: {
                this.assignColors(Color.red.darker());
                break;
            }
            case 12: {
                this.assignColors(Color.green.darker());
                break;
            }
            case 13: {
                this.assignColors(Color.cyan.darker());
                break;
            }
            case 14: {
                this.assignColors(Color.orange.darker());
                break;
            }
            case 15: {
                this.assignColors(Color.pink.darker());
                break;
            }
            case 16: {
                this.assignColors(Color.yellow.darker());
                break;
            }
            case 17: {
                this.assignColors(Color.magenta.darker());
                break;
            }
            case 18: {
                this.assignColors(Color.lightGray.darker());
                break;
            }
            case 19: {
                this.assignColors(Color.darkGray.darker());
                individualCount = 0;
                break;
            }
            default: {
                this.assignColors(this.randomColor());
            }
        }
    }

    private void assignColors(Color color) {
        this.markerColor = color;
        this.fillColor = color;
        this.lineColor = color;
    }

    public void drawArc(Graphics graphics, Point point, Point point2, int n, int n2) {
        if (this.fillColor == TRANSPARENT) {
            return;
        }
        int n3 = point.x - point2.x / 2;
        int n4 = this.globals.maxY - point.y - point2.y / 2;
        graphics.setColor(this.fillColor);
        graphics.drawArc(n3, n4, point2.x, point2.y, n, n2);
    }

    public void drawImage(Graphics graphics, Point point) {
        if (this.image != null) {
            graphics.drawImage(this.image, point.x - this.image.getWidth(null) / 2, this.globals.maxY - point.y - this.image.getHeight(null) / 2, null);
        }
    }

    public void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this.lineColor == TRANSPARENT) {
            return;
        }
        graphics.setColor(this.lineColor);
        if (this.lineWidth > 1) {
            Point[] pointArray = new Point[]{new Point(n, n2), new Point(n3, n4)};
            Gc.drawThickLine(graphics, pointArray, this.lineWidth, this.globals);
            return;
        }
        graphics.drawLine(n, this.globals.maxY - n2, n3, this.globals.maxY - n4);
    }

    public void drawLine(Graphics graphics, Point point, Point point2) {
        if (this.lineColor == TRANSPARENT) {
            return;
        }
        graphics.setColor(this.lineColor);
        if (this.lineWidth < 2) {
            graphics.drawLine(point.x, this.globals.maxY - point.y, point2.x, this.globals.maxY - point2.y);
        } else {
            Point[] pointArray = new Point[]{point, point2};
            Gc.drawThickLine(graphics, pointArray, this.lineWidth, this.globals);
        }
    }

    public void drawPolygon(Graphics graphics, Point[] pointArray) {
        if (this.fillColor == TRANSPARENT) {
            return;
        }
        graphics.setColor(this.fillColor);
        int[] nArray = new int[pointArray.length];
        int[] nArray2 = new int[pointArray.length];
        int n = 0;
        while (n < pointArray.length) {
            nArray[n] = pointArray[n].x;
            nArray2[n] = this.globals.maxY - pointArray[n].y;
            ++n;
        }
        graphics.fillPolygon(nArray, nArray2, pointArray.length);
    }

    public void drawPolyline(Graphics graphics, Point[] pointArray) {
        if (this.lineColor == TRANSPARENT) {
            return;
        }
        graphics.setColor(this.lineColor);
        if (pointArray.length == 1) {
            return;
        }
        if (this.lineWidth > 1) {
            Gc.drawThickLine(graphics, pointArray, this.lineWidth, this.globals);
            return;
        }
        int n = 1;
        while (n < pointArray.length) {
            graphics.drawLine(pointArray[n - 1].x, this.globals.maxY - pointArray[n - 1].y, pointArray[n].x, this.globals.maxY - pointArray[n].y);
            ++n;
        }
    }

    public void drawSmartString(Graphics graphics, int n, int n2, int n3, int n4, FontMetrics fontMetrics, String string) {
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        if (graphics.getColor() == TRANSPARENT) {
            return;
        }
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.globals.stringRotator != null) {
            this.globals.stringRotator.setFont(graphics.getFont());
            this.globals.stringRotator.setColor(graphics.getColor());
        } else {
            n4 = 0;
        }
        switch (n3) {
            case 0: {
                if (n4 == 0) {
                    this.drawString(graphics, n - fontMetrics.stringWidth(string) / 2, n2 - fontMetrics.getMaxAscent(), string);
                    return;
                }
                n7 = n4 < -90 || n4 > 90 ? 90 : n4;
                Rectangle rectangle = this.globals.stringRotator.getExtent(string, n, this.globals.maxY - n2, n7, fontMetrics);
                if (n7 == 90) {
                    n5 = n + fontMetrics.getMaxAscent() / 2;
                    n6 = n2 - rectangle.height;
                    break;
                }
                if (n7 > 0) {
                    n5 = n - rectangle.width + fontMetrics.getMaxAscent();
                    n6 = n2 - rectangle.height;
                    break;
                }
                n5 = n - fontMetrics.getMaxAscent() / 2;
                n6 = n2 - fontMetrics.getMaxAscent() / 2;
                break;
            }
            case 2: {
                if (n4 == 0) {
                    this.drawString(graphics, n - fontMetrics.stringWidth(string) / 2, n2, string);
                    return;
                }
                n7 = n4 < -90 || n4 > 90 ? 90 : n4;
                Rectangle rectangle = this.globals.stringRotator.getExtent(string, n, this.globals.maxY - n2, n7, fontMetrics);
                if (n7 == 90) {
                    n5 = n + fontMetrics.getMaxAscent() / 2;
                    n6 = n2;
                }
                if (n7 == -90) {
                    n5 = n - fontMetrics.getMaxAscent() / 2;
                    n6 = n2 + rectangle.height;
                    break;
                }
                if (n4 > 0) {
                    n5 = n;
                    n6 = n2;
                    break;
                }
                n5 = n - rectangle.width + fontMetrics.getMaxAscent() / 2;
                n6 = n2 + rectangle.height - fontMetrics.getMaxAscent() / 2;
                break;
            }
            case 3: {
                if (n4 == 0) {
                    this.drawString(graphics, n, n2 - fontMetrics.getHeight() / 2, string);
                    return;
                }
                n7 = n4 < -90 || n4 > 90 ? 90 : n4;
                Rectangle rectangle = this.globals.stringRotator.getExtent(string, n, this.globals.maxY - n2, n7, fontMetrics);
                n5 = n4 > 0 ? n + fontMetrics.getMaxAscent() : n;
                if (n4 == 90) {
                    n6 = n2 - fontMetrics.stringWidth(string) / 2;
                    break;
                }
                if (n4 == -90) {
                    n6 = n2 + fontMetrics.stringWidth(string) / 2;
                    break;
                }
                n6 = n2;
                break;
            }
            case 1: {
                if (n4 == 0) {
                    this.drawString(graphics, n - fontMetrics.stringWidth(string), n2 - fontMetrics.getHeight() / 2, string);
                    return;
                }
                n7 = n4 < -90 || n4 > 90 ? 90 : n4;
                Rectangle rectangle = this.globals.stringRotator.getExtent(string, n, this.globals.maxY - n2, n7, fontMetrics);
                n5 = n - rectangle.width;
                if (n4 == 90) {
                    n6 = n2 - fontMetrics.stringWidth(string) / 2;
                    break;
                }
                if (n4 == -90) {
                    n6 = n2 + fontMetrics.stringWidth(string) / 2;
                    break;
                }
                if (n4 > 0) {
                    n6 = n2 - rectangle.height + fontMetrics.getMaxAscent() / 2;
                    break;
                }
                n6 = n2 + rectangle.height - fontMetrics.getMaxAscent() / 2;
                break;
            }
            default: {
                return;
            }
        }
        this.globals.stringRotator.drawString(string, n5, this.globals.maxY - n6, n7, this.globals.image);
    }

    public void drawString(Graphics graphics, int n, int n2, String string) {
        if (graphics.getColor() == TRANSPARENT) {
            return;
        }
        try {
            graphics.drawString(string, n, this.globals.maxY - n2);
        }
        catch (NullPointerException nullPointerException) {}
    }

    private static void drawThickLine(Graphics graphics, Point[] pointArray, int n, Globals globals) {
        if (pointArray.length == 0) {
            return;
        }
        double[] dArray = new double[pointArray.length];
        double[] dArray2 = new double[pointArray.length];
        double d = n;
        int n2 = 0;
        while (n2 < pointArray.length) {
            dArray[n2] = pointArray[n2].x;
            dArray2[n2] = globals.maxY - pointArray[n2].y;
            ++n2;
        }
        double[] dArray3 = new double[dArray.length - 1];
        double[] dArray4 = new double[dArray.length - 1];
        int n3 = 1;
        while (n3 < dArray.length) {
            double d2 = Math.atan2(dArray[n3] - dArray[n3 - 1], dArray2[n3] - dArray2[n3 - 1]);
            dArray3[n3 - 1] = Math.cos(d2);
            dArray4[n3 - 1] = Math.sin(d2);
            ++n3;
        }
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        int n4 = 1;
        while (n4 < dArray.length) {
            nArray[0] = (int)(dArray[n4 - 1] + d * dArray3[n4 - 1]);
            nArray2[0] = (int)(dArray2[n4 - 1] - d * dArray4[n4 - 1]);
            nArray[1] = (int)(dArray[n4] + d * dArray3[n4 - 1]);
            nArray2[1] = (int)(dArray2[n4] - d * dArray4[n4 - 1]);
            nArray[2] = (int)(dArray[n4] - d * dArray3[n4 - 1]);
            nArray2[2] = (int)(dArray2[n4] + d * dArray4[n4 - 1]);
            nArray[3] = (int)(dArray[n4 - 1] - d * dArray3[n4 - 1]);
            nArray2[3] = (int)(dArray2[n4 - 1] + d * dArray4[n4 - 1]);
            graphics.fillPolygon(nArray, nArray2, 4);
            ++n4;
        }
        n4 = 1;
        while (n4 < dArray.length - 1) {
            graphics.fillOval((int)(dArray[n4] - d), (int)(dArray2[n4] - d), (int)d * 2, (int)d * 2);
            ++n4;
        }
    }

    public void fillArc(Graphics graphics, Point point, Point point2, int n, int n2) {
        if (this.fillColor == TRANSPARENT) {
            return;
        }
        int n3 = point.x - point2.x / 2;
        int n4 = this.globals.maxY - point.y - point2.y / 2;
        graphics.setColor(this.fillColor);
        graphics.fillArc(n3, n4, point2.x, point2.y, n, n2);
    }

    public void fillRect(Graphics graphics, Point point, int n, int n2) {
        if (this.fillColor == TRANSPARENT) {
            return;
        }
        graphics.setColor(this.fillColor);
        graphics.fillRect(point.x, point.y, n, n2);
    }

    public void fillRect(Graphics graphics, Point point, Point point2) {
        int n;
        int n2;
        if (this.fillColor == TRANSPARENT) {
            return;
        }
        if (point.x > point2.x) {
            n2 = point2.x;
            n = point.x;
        } else {
            n2 = point.x;
            n = point2.x;
        }
        graphics.setColor(this.fillColor);
        if (point2.y > point.y) {
            graphics.fillRect(n2, this.globals.maxY - point2.y, n - n2, point2.y - point.y);
        } else {
            graphics.fillRect(n2, this.globals.maxY - point.y, n - n2, point.y - point2.y);
        }
    }

    public static String formattedLabel(String string, int n, int n2) {
        int n3 = string.lastIndexOf(".");
        if (n3 != -1) {
            int n4 = string.length();
            if (n2 == 0 || n3 == n4 - 2 && string.charAt(n4 - 1) == '0') {
                string = string.substring(0, n3);
            } else if (n4 > 1 + n3 + n2) {
                string = string.substring(0, n3 + 1 + n2);
            }
        }
        if (n == 0) {
            return string;
        }
        int n5 = n == 1 ? 44 : 46;
        int n6 = string.indexOf(46);
        if (n6 == -1) {
            n6 = string.length();
        } else if (n == 2) {
            string = string.replace('.', ',');
        }
        char[] cArray = n6 % 3 != 0 ? new char[string.length() + n6 / 3] : new char[string.length() + n6 / 3 - 1];
        char[] cArray2 = string.toCharArray();
        n3 = cArray2.length - 1;
        int n7 = cArray.length - 1;
        while (n3 >= n6) {
            cArray[n7] = cArray2[n3];
            --n7;
            --n3;
        }
        int n8 = cArray2[0] == '-' ? 1 : 0;
        n7 = 0;
        n3 = 0;
        while (n3 < n6) {
            if ((n6 - n3) % 3 == 0 && n7 > n8 && n3 < n6) {
                cArray[n7] = n5;
                ++n7;
            }
            cArray[n7] = cArray2[n3];
            ++n3;
            ++n7;
        }
        return new String(cArray);
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public Image getImage() {
        return this.image;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public static String nonSciNumberStr(String string, int n) {
        char[] cArray = null;
        int n2 = string.indexOf(43);
        int n3 = n2 == -1 ? Integer.parseInt(string.substring(n + 1)) : Integer.parseInt(string.substring(n2 + 1));
        String string2 = string.substring(0, n).trim();
        int n4 = string2.indexOf(46);
        n2 = n4 == -1 ? (n3 > 0 ? n3 : -n3) : (n3 > 0 ? n3 - (string2.length() - n4) + 1 : -n3 - n4);
        if (n2 > 0) {
            cArray = new char[n2];
            n2 = 0;
            while (n2 < cArray.length) {
                cArray[n2] = 48;
                ++n2;
            }
        }
        if (n4 == -1) {
            if (n3 < 0) {
                return "0." + cArray + string2;
            }
            return String.valueOf(string2) + cArray;
        }
        if (n3 < 0) {
            return "0." + cArray + string2.substring(0, n4) + string2.substring(n4 + 1);
        }
        if (cArray != null) {
            return String.valueOf(string2.substring(0, n4)) + string2.substring(n4 + 1) + cArray;
        }
        int n5 = string2.length() + n2;
        return String.valueOf(string2.substring(0, n4)) + string2.substring(n4 + 1, n5) + '.' + string2.substring(n5);
    }

    private Color randomColor() {
        float f = (float)Math.random();
        float f2 = (float)Math.random();
        float f3 = (float)Math.random();
        return new Color(f, f2, f3);
    }

    public void setFillColor(Color color) {
        this.fillColor = color;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setLineStyle(int n) {
        this.lineStyle = n;
    }

    public void setLineWidth(int n) {
        this.lineWidth = n;
    }

    public void setMarkerColor(Color color) {
        this.markerColor = color;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public void setMarkerStyle(int n) {
        this.markerStyle = n;
    }
}

