#!/usr/local/bin/perl 
#05/02/01
#-msadikun

######################################################
#-How to use: ./atapost.pl -rxcodec=3 -txcodec=1
######################################################
use HTTP::Request::Common; 
use LWP::UserAgent;
&GetArg();
&GetConfig();
&PostConfig();

######################################################
#			GetArg
######################################################
sub GetArg 
 {
  my ($elem,$c1,$c2);

  &Usage() if ($#ARGV < 1); #-no argument
  $IPaddress = $ARGV[0];
  $URL = "http://$IPaddress/dev/index.html";

  for $elem (@ARGV) {
    ($c1,$c2) = split (/=/,$elem);
    &Usage() if (($c1 =~ "-help") || ($c1 =~ "-h\$")); 
    $c1 =~ s/-//;
    $c1 =~ tr/A-Z/a-z/;
    #-print "add $c1 with value $c2 \n" if ($c2); #-debug
    $cmd_arg{$c1}=$c2 if ($c2); #-if $c2 is not junk, i.e: -debug
   }
 }#GetArg

######################################################
#			Usage
######################################################
sub Usage
 {
   print "
        Synopsys:
        ---------
        Program $0 
        is to post field container to one ATA186 via http protocol, 
        given it's IP.

        Usage:
        ------
        $0 [-h]elp | <ipaddress> <-field1=one> <-field2=two> <-...>
      
        	-h: 		This help information
		<ipaddress>:	it's in the form of W.X.Y.Z	
		<-field1=..>:	value of \"-field1\" to change

        Example 
        To change ata with ip=192.168.2.119 to use codec G723:

        unix-prompt%> $0 192.168.2.119 -txcodec=1 -rxcodec=1
	Establishing connection...
	Connected.
	Changing TxCodec to new value = 1
	Changing RxCodec to new value = 1
	done.

        Requirement:
        ------------
        -) ATA186 version 2.0
";
   exit 1;
 }#Usage

######################################################
#			GetConfig
######################################################
sub GetConfig
 {
  my ($elem,$c1,$junk,$req,$res);

  $ua=LWP::UserAgent->new;

  #$req= (GET 'http://sobe.cisco.com:8080/cgi-bin/provision/displaycfg.pl?box=ata2468716.cfg');
  if ($IPaddress) { $req= (GET "$URL"); }
  else 
	{ print "don't know what ip address"; exit 1; }

  print "Establishing connection...\n";
  $res=$ua->request($req);
  if ($res->is_success) { print "Connected to $IPaddress.\n"; }
  else { print "ERROR: Problem retrieving data from $IPaddress\n"; exit 1; }

  @content=split (/name="/,$res->as_string);
  for $elem (@content) {
    ($c1,$junk)=split (/">/,$elem); #-strip junks
    ($name,$value)=split (/" Value="/,$c1); #-only care about name & value field
    $lowercase=$name;
    ($lowercase) =~ tr/A-Z/a-z/;	#-this will allow lowercase in cmd argument
    #($lowercase) = $name =~ tr/A-Z/a-z/;
    if ($cmd_arg{$lowercase}) {
       print "Changing $name, new value = $cmd_arg{$lowercase}...\n";
       $fields=sprintf ("%s%s",$fields,"$name=$cmd_arg{$lowercase}&");
      }
    else {
       #print "$name=$value\n";
       $fields=sprintf ("%s%s",$fields,"$name=$value&") if ($value);
      }
    }#for

    chop ($fields); #-take out the last &
#  for $elem (@fields) { $elem =~ s/ //; } #-getrid of blanks
 }#GetConfig

######################################################
#			PostConfig
######################################################
sub PostConfig
 {
  my ($ua,$req,$res);
  $ua=LWP::UserAgent->new;

  #$req=(POST 'http://sobe.cisco.com:8080/cgi-bin/provision/modifybox.pl');
  #if ($IPaddress) { $req= (POST 'http://192.168.3.119/dev/index.html'); }
  if ($IPaddress) { $req= (POST "$URL"); }
  else 
	{ print "don't know what ip address"; exit 1; }
  $req->content_type ('application/x-www-form-urlencoded');
  $req->content("$fields");	#-fields that I will post
  #$req->content('box=ata2468716.cfg&RxCodec=2&Dhcp=4');

  $res=$ua->request($req);

  if ($res->is_success) {
    #print $res->content;
    #print $res->as_string;	#-print to screen if debugging
  }
  else { 
     #print $res->error_as_HTML;
     print "ERROR: connection problem, perhaps box with $IPaddress is not ready?\n";
  }
  print "Done.\n";
 }#PostConfig


#$Id: atapost.pl,v 1.1 2001-05-10 13:25:27-07 msadikun Exp msadikun $#
