/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.core;

import com.cisco.uct.db.UctDatabaseManager;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.UctLog;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParseAxlLicenseResponse {
    private String responseFile1;
    private String responseFile2;
    private String hostname;
    private Connection dbConnection = null;

    public ParseAxlLicenseResponse(String string) {
        UctDatabaseManager uctDatabaseManager = new UctDatabaseManager();
        this.dbConnection = uctDatabaseManager.connectApacheDB();
        this.hostname = string;
        this.responseFile1 = UserCountUtility.home_dir + "//dist/" + string + "sample1.response";
        this.responseFile2 = UserCountUtility.home_dir + "//dist/" + string + "sample2.response";
        UctLog.info("Parsing the device type count for the cluster " + this.hostname);
        this.parse_response();
        UctLog.info("Device type count parsing done for the cluster " + this.hostname);
        UctLog.info("Parsing the DLU information for the cluster " + this.hostname);
        this.parse_response_DLUs();
        UctLog.info("DLU information parsing done for the cluster " + this.hostname);
    }

    public void parse_response() {
        try {
            File file = new File(this.responseFile1);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("row");
            UctLog.info("Inserting the device type information into the DB");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = this.getTagValue("enduser_pkid", element);
                String string2 = this.getTagValue("hasemavailable", element);
                String string3 = this.getTagValue("hassnravailable", element);
                String string4 = this.getTagValue("tinclassdevicecount", element);
                String string5 = this.getTagValue("copperclassdevicecount", element);
                String string6 = this.getTagValue("bronzeclassdevicecount", element);
                String string7 = this.getTagValue("silverclassdevicecount", element);
                String string8 = this.getTagValue("goldclassdevicecount", element);
                String string9 = this.getTagValue("telepresenceclassdevicecount", element);
                String string10 = this.getTagValue("hasimandpresence", element);
                String string11 = this.getTagValue("unknownclassdevicecount", element);
                System.out.println("Hi" + string + string2 + string3 + string4 + string5 + string6 + string7);
                int n = Integer.parseInt(string4);
                int n2 = Integer.parseInt(string5);
                int n3 = Integer.parseInt(string6);
                int n4 = Integer.parseInt(string7);
                int n5 = Integer.parseInt(string8);
                int n6 = Integer.parseInt(string9);
                int n7 = Integer.parseInt(string11);
                String string12 = "INSERT INTO tempusage(userid, emusage, snrusage, tinusage, copperusage, bronzeusage, silverusage, goldusage, telepresenceusage, impresenceusage,unknownclassdevicecount,hostname) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
                PreparedStatement preparedStatement = this.dbConnection.prepareStatement(string12);
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                preparedStatement.setString(3, string3);
                preparedStatement.setInt(4, n);
                preparedStatement.setInt(5, n2);
                preparedStatement.setInt(6, n3);
                preparedStatement.setInt(7, n4);
                preparedStatement.setInt(8, n5);
                preparedStatement.setInt(9, n6);
                preparedStatement.setString(10, string10);
                preparedStatement.setInt(11, n7);
                preparedStatement.setString(12, this.hostname);
                preparedStatement.executeUpdate();
            }
            UctLog.info("Insertion of the device type information into the DB done");
        }
        catch (Exception exception) {
            UctLog.error("Exception occured while parsing the device type count information for the cluster " + this.hostname + ". Error: " + exception.getMessage());
        }
    }

    public void parse_response_DLUs() {
        Object object;
        Object object2;
        int n = 0;
        int n2 = 0;
        try {
            File file = new File(this.responseFile2);
            object2 = DocumentBuilderFactory.newInstance();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            Document document = ((DocumentBuilder)object).parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("row");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                String string = this.getTagValue("total", element);
                String string2 = this.getTagValue("used", element);
                int n3 = Integer.parseInt(string);
                int n4 = Integer.parseInt(string2);
                n = ParseAxlLicenseResponse.safeAdd(n, n3);
                n2 = ParseAxlLicenseResponse.safeAdd(n2, n4);
            }
        }
        catch (Exception exception) {
            UctLog.error("Exception occured while parsing the AXL response for getting DLU information for the cluster " + this.hostname + ". Error: " + exception.getMessage());
        }
        try {
            int n5 = n - n2;
            UctLog.info("Inserting DLU information for the cluster " + this.hostname);
            object2 = "INSERT INTO licensecount(UNUSED, HOSTNAME) VALUES(?,?)";
            object = this.dbConnection.prepareStatement((String)object2);
            object.setInt(1, n5);
            object.setString(2, this.hostname);
            object.executeUpdate();
            UctLog.info("Insertion of DLU information done for the cluster" + this.hostname);
            this.dbConnection.close();
            UctLog.info("DB connection closed");
        }
        catch (Exception exception) {
            UctLog.error("SQL Exception occured while inserting the DLU information for the cluster " + this.hostname + ". Error: " + exception.getMessage());
        }
    }

    private String getTagValue(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
        Node node = nodeList.item(0);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    static final int safeAdd(int n, int n2) throws ArithmeticException {
        if (n2 > 0 ? n > Integer.MAX_VALUE - n2 : n < Integer.MIN_VALUE - n2) {
            throw new ArithmeticException("Integer overflow");
        }
        return n + n2;
    }
}

