/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.db;

import com.cisco.uct.ui.Spinner;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.ClusterData;
import com.cisco.uct.utils.Localization;
import com.cisco.uct.utils.Password;
import com.cisco.uct.utils.PasswordEncryption;
import com.cisco.uct.utils.UctLog;
import java.awt.Color;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class UctDatabaseManager {
    String userid = "root";
    String password = "cisco";
    String apacheURL = "jdbc:derby:" + UserCountUtility.home_dir + "//db/uct;create=true";
    String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    Connection apacheconn = null;
    ArrayList tableList = new ArrayList();
    private String dupmsg_err;
    private static UctDatabaseManager dbinstance;
    JLabel label = null;
    private Localization localemsg = new Localization();

    public UctDatabaseManager() {
        System.setProperty("derby.system.home", UserCountUtility.home_dir + "//db/");
        this.connectApacheDB();
        this.createTables();
        UctLog.info("Initialization of DB completed");
    }

    public static synchronized UctDatabaseManager getDBinstance() {
        if (dbinstance == null) {
            dbinstance = new UctDatabaseManager();
        }
        return dbinstance;
    }

    public void deletetable() {
        String string = "DROP TABLE LICENSECOUNT";
        try {
            Statement statement = this.apacheconn.createStatement();
            statement.execute(string);
        }
        catch (Exception exception) {
            UctLog.error("SQL Execption occoured while droping the table: " + exception.getMessage());
        }
    }

    private void createTables() {
        try {
            String string = "CREATE TABLE CLUSTER (HOSTNAME VARCHAR(40) NOT NULL PRIMARY KEY, USERNAME VARCHAR(40), PASSWORD VARCHAR(40),DESCRIPTION VARCHAR(40),VERSION VARCHAR(40),ConnectionStatus VARCHAR(40),CHECKBOXSTATUS VARCHAR(1))";
            String string2 = "CREATE TABLE TEMPUSAGE (USERID VARCHAR(40), EMUSAGE VARCHAR(5), SNRUSAGE VARCHAR(5), TINUSAGE INTEGER, COPPERUSAGE INTEGER, BRONZEUSAGE INTEGER, SILVERUSAGE INTEGER, GOLDUSAGE INTEGER,TELEPRESENCEUSAGE INTEGER, IMPRESENCEUSAGE VARCHAR(10), UNKNOWNCLASSDEVICECOUNT INTEGER, HOSTNAME VARCHAR(40))";
            String string3 = "CREATE TABLE LICENSECOUNT (HOSTNAME VARCHAR(40),  PROFESSIONAL INTEGER, ENHANCEDPLUS INTEGER, STANDARD INTEGER, ENHANCED INTEGER, BASIC INTEGER, ESSENTIAL INTEGER, UNUSED INTEGER, TELEPRESENCE INTEGER, IMPRESENCE INTEGER)";
            String string4 = "CREATE TABLE PASSWORD (FLAG VARCHAR(40), PASSWORD VARCHAR(40))";
            Statement statement = this.apacheconn.createStatement();
            this.tableList = this.getTableList();
            if (!this.tableList.contains("CLUSTER")) {
                UctLog.info("Creating the CLUSTER table");
                statement.executeUpdate(string);
            }
            if (!this.tableList.contains("TEMPUSAGE")) {
                UctLog.info("Creating the TEMPUSAGE table");
                statement.executeUpdate(string2);
            }
            if (!this.tableList.contains("LICENSECOUNT")) {
                UctLog.info("Creating the LICENSECOUNT table");
                statement.executeUpdate(string3);
            }
            if (!this.tableList.contains("PASSWORD")) {
                UctLog.info("Creating the PASSWORD table");
                statement.executeUpdate(string4);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            UctLog.error("SQLException while verifying the tables" + sQLException);
        }
    }

    public Connection connectApacheDB() {
        UctLog.info("Connecting to the database");
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException classNotFoundException) {
            UctLog.error("ClassNotFoundException:-" + classNotFoundException.getMessage());
        }
        try {
            this.apacheconn = DriverManager.getConnection(this.apacheURL, this.userid, this.password);
            UctLog.info("Connected to the database");
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while connecting to the database:" + sQLException.getMessage());
        }
        return this.apacheconn;
    }

    private ArrayList getTableList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DatabaseMetaData databaseMetaData = this.apacheconn.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, "%", stringArray);
            while (resultSet.next()) {
                String string = resultSet.getString("TABLE_NAME");
                arrayList.add(string);
                UctLog.info("The table that is there in the database: " + string);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            UctLog.info("No tables in the database" + sQLException);
        }
        return arrayList;
    }

    public ResultSet searchCluster(String string) {
        UctLog.info("Searching the database for the cluster " + string);
        ResultSet resultSet = null;
        try {
            String string2 = "SELECT * FROM CLUSTER WHERE hostname like '%" + string + "%'";
            Statement statement = this.apacheconn.createStatement();
            resultSet = statement.executeQuery(string2);
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while seraching for the cluster " + string + ". Error: " + sQLException);
        }
        return resultSet;
    }

    public ResultSet searchPassword() {
        UctLog.info("Checking if the password is already set");
        ResultSet resultSet = null;
        try {
            String string = "SELECT * FROM PASSWORD";
            Statement statement = this.apacheconn.createStatement();
            resultSet = statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            UctLog.error("SQLException occured while checking the saved Password. Error: " + sQLException);
        }
        return resultSet;
    }

    public int refresh(JTable jTable, String string) {
        String string2 = null;
        int n = 0;
        String[] stringArray = new String[5000];
        String[] stringArray2 = new String[5000];
        String[] stringArray3 = new String[5000];
        String[] stringArray4 = new String[5000];
        String[] stringArray5 = new String[5000];
        int n2 = 0;
        ((DefaultTableModel)jTable.getModel()).setNumRows(0);
        try {
            Statement statement = this.apacheconn.createStatement();
            string2 = "SELECT * FROM CLUSTER ORDER BY HOSTNAME";
            ResultSet resultSet = statement.executeQuery(string2);
            int n3 = 0;
            while (resultSet.next()) {
                if (n3 >= 100) continue;
                stringArray[n3] = resultSet.getString(1);
                stringArray2[n3] = resultSet.getString(4);
                stringArray3[n3] = resultSet.getString(5);
                stringArray4[n3] = resultSet.getString(6);
                stringArray5[n3] = resultSet.getString(7);
                ++n3;
            }
            resultSet.close();
            statement.close();
            n2 = n3;
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while getting the values from the database table to refresh the UCT main Table. Error: " + sQLException);
        }
        jTable.setAutoCreateRowSorter(true);
        for (int i = 0; i < n2; ++i) {
            ((DefaultTableModel)jTable.getModel()).insertRow(i, new Object[0]);
            if (stringArray[i].equals(string)) {
                n = i;
            }
            jTable.setValueAt(stringArray[i], i, 0);
            jTable.setValueAt(stringArray2[i], i, 1);
            jTable.setValueAt(stringArray3[i], i, 2);
            jTable.setValueAt(stringArray4[i], i, 3);
            if (stringArray5[i].equals("T")) {
                jTable.setValueAt(true, i, 4);
                continue;
            }
            jTable.setValueAt(false, i, 4);
        }
        return n;
    }

    public void delete(String string) {
        try {
            UctLog.info("Deleting the details for the cluster " + string);
            String string2 = "DELETE FROM CLUSTER WHERE hostname like '%" + string + "%'";
            PreparedStatement preparedStatement = this.apacheconn.prepareStatement(string2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            UctLog.error("SQLException ocured while deleting the cluster " + string + ". Error: " + sQLException);
        }
    }

    public void refreshLicense(JTable jTable, JTable jTable2) {
        ResultSet resultSet;
        Statement statement;
        String string = null;
        String string2 = null;
        String string3 = "select sum(essential),sum(basic),sum(enhanced), sum(enhancedplus), sum(Standard),  sum(professional), sum(telepresence),  sum(unused)  from LICENSECOUNT";
        ((DefaultTableModel)jTable.getModel()).setNumRows(0);
        jTable.setAutoCreateRowSorter(true);
        ((DefaultTableModel)jTable2.getModel()).setNumRows(0);
        jTable2.setAutoCreateRowSorter(true);
        try {
            statement = this.apacheconn.createStatement();
            string = "SELECT HOSTNAME, ESSENTIAL, BASIC, ENHANCED, ENHANCEDPLUS, STANDARD, PROFESSIONAL, TELEPRESENCE, UNUSED  FROM LICENSECOUNT";
            resultSet = statement.executeQuery(string);
            int n = 0;
            String string4 = null;
            while (resultSet.next()) {
                if (n >= 100) continue;
                ((DefaultTableModel)jTable.getModel()).insertRow(n, new Object[0]);
                string2 = resultSet.getString(1);
                jTable.setValueAt(string2, n, 0);
                String string5 = "SELECT description, ConnectionStatus from cluster where hostname IN ('" + string2 + "')";
                Statement statement2 = this.apacheconn.createStatement();
                ResultSet resultSet2 = statement2.executeQuery(string5);
                while (resultSet2.next()) {
                    string4 = resultSet2.getString(2);
                    jTable.setValueAt(resultSet2.getString(1), n, 1);
                }
                if (string4.equals(this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT"))) {
                    jTable.setValueAt("-", n, 2);
                    jTable.setValueAt("-", n, 3);
                    jTable.setValueAt("-", n, 4);
                    jTable.setValueAt("-", n, 5);
                    jTable.setValueAt("-", n, 6);
                    jTable.setValueAt("-", n, 7);
                    jTable.setValueAt("-", n, 8);
                    jTable.setValueAt("-", n, 9);
                } else {
                    jTable.setValueAt(resultSet.getInt(2), n, 2);
                    jTable.setValueAt(resultSet.getInt(3), n, 3);
                    jTable.setValueAt(resultSet.getInt(4), n, 4);
                    jTable.setValueAt(resultSet.getInt(5), n, 5);
                    jTable.setValueAt(resultSet.getInt(6), n, 6);
                    jTable.setValueAt(resultSet.getInt(7), n, 7);
                    jTable.setValueAt(resultSet.getInt(8), n, 8);
                    jTable.setValueAt(resultSet.getInt(9), n, 9);
                }
                ++n;
            }
            if (UserCountUtility.osname.contains("mac")) {
                while (n < 6) {
                    ((DefaultTableModel)jTable.getModel()).insertRow(n, new Object[0]);
                    jTable.setValueAt("", n, 0);
                    jTable.setValueAt("", n, 1);
                    jTable.setValueAt("", n, 2);
                    jTable.setValueAt("", n, 3);
                    jTable.setValueAt("", n, 4);
                    jTable.setValueAt("", n, 5);
                    jTable.setValueAt("", n, 6);
                    jTable.setValueAt("", n, 7);
                    jTable.setValueAt("", n, 8);
                    jTable.setValueAt("", n, 9);
                    ++n;
                }
            } else {
                while (n < 5) {
                    ((DefaultTableModel)jTable.getModel()).insertRow(n, new Object[0]);
                    jTable.setValueAt("", n, 0);
                    jTable.setValueAt("", n, 1);
                    jTable.setValueAt("", n, 2);
                    jTable.setValueAt("", n, 3);
                    jTable.setValueAt("", n, 4);
                    jTable.setValueAt("", n, 5);
                    jTable.setValueAt("", n, 6);
                    jTable.setValueAt("", n, 7);
                    jTable.setValueAt("", n, 8);
                    jTable.setValueAt("", n, 9);
                    ++n;
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while calculating the license usage details. Error: " + sQLException);
        }
        try {
            statement = this.apacheconn.createStatement();
            resultSet = statement.executeQuery(string3);
            while (resultSet.next()) {
                ((DefaultTableModel)jTable2.getModel()).insertRow(0, new Object[0]);
                jTable2.setValueAt(this.localemsg.bundle.getString("UCT.LICENSEREPORTTOTAL.TEXT"), 0, 0);
                jTable2.setValueAt("", 0, 1);
                jTable2.setValueAt(resultSet.getInt(1), 0, 2);
                jTable2.setValueAt(resultSet.getInt(2), 0, 3);
                jTable2.setValueAt(resultSet.getInt(3), 0, 4);
                jTable2.setValueAt(resultSet.getInt(4), 0, 5);
                jTable2.setValueAt(resultSet.getInt(5), 0, 6);
                jTable2.setValueAt(resultSet.getInt(6), 0, 7);
                jTable2.setValueAt(resultSet.getInt(7), 0, 8);
                jTable2.setValueAt(resultSet.getInt(8), 0, 9);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while calculating the total sum for license usage table and also calculating the license planning worksheet details" + sQLException);
        }
    }

    public void refreshLicensePlan(String string, JSpinner jSpinner, JTable jTable, JTable jTable2, JTable jTable3, JLabel jLabel) {
        int n;
        Object object;
        jTable2.setAutoCreateRowSorter(true);
        String string2 = "select sum(professional),sum(Standard),sum(enhancedplus),sum(enhanced),sum(basic),sum(essential), sum(telepresence) from LICENSECOUNT";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        try {
            object = this.apacheconn.createStatement();
            ResultSet resultSet = object.executeQuery(string2);
            while (resultSet.next()) {
                n12 = resultSet.getInt(1);
                n10 = resultSet.getInt(2);
                n8 = resultSet.getInt(3);
                n6 = resultSet.getInt(4);
                n4 = resultSet.getInt(5);
                n2 = resultSet.getInt(6);
                n14 = resultSet.getInt(7);
            }
            resultSet.close();
            object.close();
        }
        catch (Exception exception) {
            UctLog.info("Exception occured during calculating the License total values: Error:" + exception);
        }
        if (string.equals(this.localemsg.bundle.getString("UCT.LICENSEREPORT.DISPLAYMODE.COMBOBOX.OPTION1.TEXT"))) {
            n13 = n12;
            n11 = n10;
            n9 = n8;
            n7 = n6;
            n5 = n4;
            n3 = n2;
            n15 = n14;
        } else if (string.equals(this.localemsg.bundle.getString("UCT.LICENSEREPORT.DISPLAYMODE.COMBOBOX.OPTION2.TEXT"))) {
            object = jSpinner.getValue().toString();
            int n16 = Integer.parseInt((String)object);
            if (n2 + n4 + n6 + n8 > n16 && n16 != 0) {
                if (n2 > n16) {
                    n13 = n12;
                    n11 = n10 + n8 + n4 + n6;
                    n9 = 0;
                    n7 = 0;
                    n5 = 0;
                    n3 = n2;
                    n15 = n14;
                } else {
                    n13 = n12;
                    n15 = n14;
                    n3 = n2;
                    n11 = n10;
                    if (n4 <= (n16 -= n2)) {
                        n5 = n4;
                        n16 -= n4;
                    } else {
                        n5 = n16;
                        n11 += n4 - n16;
                        n16 = 0;
                    }
                    if (n6 <= n16) {
                        n7 = n6;
                        n16 -= n6;
                    } else {
                        n7 = n16;
                        n11 += n6 - n16;
                        n16 = 0;
                    }
                    if (n8 <= n16) {
                        n9 = n8;
                        n16 -= n8;
                    } else {
                        n9 = n16;
                        n11 += n8 - n16;
                        n16 = 0;
                    }
                }
            } else if (n2 + n4 + n6 + n8 <= n16) {
                n13 = n12;
                n11 = n10;
                n9 = n8;
                n7 = n6;
                n5 = n4;
                n3 = n2;
                n15 = n14;
            } else if (n16 == 0) {
                n13 = n12;
                n11 = n8 + n6 + n4 + n10;
                n9 = 0;
                n7 = 0;
                n5 = 0;
                n3 = n2;
                n15 = n14;
            }
        }
        int n17 = 0;
        int n18 = 0;
        jTable2.setValueAt(n12, 0, 1);
        jTable2.setValueAt(n13, 0, 2);
        jTable2.setValueAt(n13, 0, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(0, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(0, 4).toString()) - Integer.parseInt(jTable2.getValueAt(0, 4).toString());
        jTable2.setValueAt(n18 * n17, 0, 6);
        jTable2.setValueAt(n10, 1, 1);
        jTable2.setValueAt(n11, 1, 2);
        jTable2.setValueAt(n11, 1, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(1, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(1, 4).toString()) - Integer.parseInt(jTable2.getValueAt(1, 4).toString());
        jTable2.setValueAt(n18 * n17, 1, 6);
        jTable2.setValueAt(n8, 2, 1);
        jTable2.setValueAt(n9, 2, 2);
        jTable2.setValueAt(n9, 2, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(2, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(2, 4).toString()) - Integer.parseInt(jTable2.getValueAt(2, 4).toString());
        jTable2.setValueAt(n18 * n17, 2, 6);
        jTable2.setValueAt(n6, 3, 1);
        jTable2.setValueAt(n7, 3, 2);
        jTable2.setValueAt(n7, 3, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(3, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(3, 4).toString()) - Integer.parseInt(jTable2.getValueAt(3, 4).toString());
        jTable2.setValueAt(n18 * n17, 3, 6);
        jTable2.setValueAt(n4, 4, 1);
        jTable2.setValueAt(n5, 4, 2);
        jTable2.setValueAt(n5, 4, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(4, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(4, 4).toString()) - Integer.parseInt(jTable2.getValueAt(4, 4).toString());
        jTable2.setValueAt(n18 * n17, 4, 6);
        jTable2.setValueAt(n2, 5, 1);
        jTable2.setValueAt(n3, 5, 2);
        jTable2.setValueAt(n3, 5, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(5, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(5, 4).toString()) - Integer.parseInt(jTable2.getValueAt(5, 4).toString());
        jTable2.setValueAt(n18 * n17, 5, 6);
        jTable2.setValueAt(n14, 6, 1);
        jTable2.setValueAt(n15, 6, 2);
        jTable2.setValueAt(n15, 6, 4);
        n17 = Integer.parseInt(jTable2.getValueAt(6, 5).toString());
        n18 = Integer.parseInt(jTable2.getValueAt(6, 4).toString()) - Integer.parseInt(jTable2.getValueAt(6, 4).toString());
        jTable2.setValueAt(n18 * n17, 6, 6);
        int n19 = 0;
        for (n = 0; n < 7; ++n) {
            n19 += Integer.parseInt(jTable2.getValueAt(n, 6).toString());
        }
        jTable3.setValueAt(n19, 0, 0);
        n = Integer.parseInt(jTable.getValueAt(0, 9).toString()) - Integer.parseInt(jTable3.getValueAt(0, 0).toString());
        if (n >= 0) {
            jLabel.setText("" + n);
            jLabel.setForeground(Color.BLACK);
            UserCountUtility.warningLabel.setVisible(false);
        } else {
            jLabel.setText("" + n);
            jLabel.setForeground(Color.RED);
            UserCountUtility.warningLabel.setVisible(true);
        }
        new Spinner(UserCountUtility.Licenseplanningtable, 3, UserCountUtility.licenseplanningtotaltable, UserCountUtility.unuseddluremainingLabel, UserCountUtility.totalcounttable, UserCountUtility.warningLabel).reset();
    }

    public String saveCluster(ClusterData clusterData) {
        this.dupmsg_err = null;
        try {
            UctLog.info("Saving the details for the cluster " + clusterData.getHostname());
            String string = "INSERT INTO CLUSTER(hostname, username, password, description, version, connectionstatus, checkboxstatus) VALUES(?,?,?,?,?,?,?)";
            PreparedStatement preparedStatement = this.apacheconn.prepareStatement(string);
            preparedStatement.setString(1, clusterData.getHostname());
            preparedStatement.setString(2, clusterData.getUsername());
            preparedStatement.setString(3, clusterData.getPassword());
            preparedStatement.setString(4, clusterData.getDescription());
            preparedStatement.setString(5, clusterData.getVersion());
            preparedStatement.setString(6, clusterData.getStatus());
            System.out.println("Hello" + clusterData.getStatus().toString());
            if (clusterData.getStatus().toString().equals(this.localemsg.bundle.getString("UCT.AXL.SUCCESS.TEXT"))) {
                preparedStatement.setString(7, "T");
            } else {
                preparedStatement.setString(7, "F");
            }
            preparedStatement.executeUpdate();
            UctLog.info("Saved the details for the cluster " + clusterData.getHostname());
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while saving the cluster details in the database:" + sQLException.getMessage());
            this.dupmsg_err = sQLException.getMessage();
        }
        return this.dupmsg_err;
    }

    public void updateCluster(ClusterData clusterData, boolean bl) {
        try {
            UctLog.info("Updating the details for the cluster " + clusterData.getHostname());
            String string = "UPDATE CLUSTER SET username= ?, password=?, description=?, version=?, connectionstatus=?, checkboxstatus=? where hostname='" + clusterData.getHostname() + "'";
            PreparedStatement preparedStatement = this.apacheconn.prepareStatement(string);
            preparedStatement.setString(1, clusterData.getUsername());
            preparedStatement.setString(2, clusterData.getPassword());
            preparedStatement.setString(3, clusterData.getDescription());
            preparedStatement.setString(4, clusterData.getVersion());
            preparedStatement.setString(5, clusterData.getStatus());
            if (!bl) {
                if (clusterData.getStatus().toString().equals(this.localemsg.bundle.getString("UCT.AXL.SUCCESS.TEXT"))) {
                    preparedStatement.setString(6, "T");
                } else {
                    preparedStatement.setString(6, "F");
                }
            } else {
                String string2 = "SELECT checkboxstatus FROM CLUSTER where hostname='" + clusterData.getHostname() + "'";
                Statement statement = this.apacheconn.createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                while (resultSet.next()) {
                    preparedStatement.setString(6, resultSet.getString(1));
                }
            }
            preparedStatement.executeUpdate();
            preparedStatement.close();
            UctLog.info("Updated the details for the cluster " + clusterData.getHostname());
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while updating the edited cluster details in the database. Error: " + sQLException.getMessage());
        }
    }

    public void addPassword(Password password) {
        try {
            UctLog.info("Saving the password");
            PasswordEncryption passwordEncryption = new PasswordEncryption(password.getPassword());
            String string = passwordEncryption.encryptUCTPassword(password.getPassword());
            String string2 = "INSERT INTO PASSWORD(flag, password) VALUES(?,?)";
            String string3 = "DELETE FROM PASSWORD";
            PreparedStatement preparedStatement = this.apacheconn.prepareStatement(string3);
            PreparedStatement preparedStatement2 = this.apacheconn.prepareStatement(string2);
            preparedStatement2.setString(1, "1");
            preparedStatement2.setString(2, string);
            preparedStatement.executeUpdate();
            preparedStatement2.executeUpdate();
            UctLog.info("Password saved");
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exception occured while saving the newly added password details in the database. Error: " + sQLException.getMessage());
        }
    }

    public String getPassword() {
        String string = null;
        try {
            String string2 = "SELECT PASSWORD FROM PASSWORD";
            Statement statement = this.apacheconn.createStatement();
            ResultSet resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                string = resultSet.getString(1);
            }
            return string;
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exeception occured while retriving the stored password. Error: " + sQLException);
            return null;
        }
    }

    public void deleteDatabase() {
        try {
            String string = "DELETE FROM LICENSECOUNT";
            String string2 = "DELETE FROM CLUSTER";
            String string3 = "DELETE FROM TEMPUSAGE";
            String string4 = "DELETE FROM PASSWORD";
            PreparedStatement preparedStatement = this.apacheconn.prepareStatement(string);
            preparedStatement.executeUpdate();
            preparedStatement = this.apacheconn.prepareStatement(string2);
            preparedStatement.executeUpdate();
            preparedStatement = this.apacheconn.prepareStatement(string3);
            preparedStatement.executeUpdate();
            preparedStatement = this.apacheconn.prepareStatement(string4);
            preparedStatement.executeUpdate();
            this.apacheconn.close();
            UctLog.info("Database deleted on startover");
            UctDatabaseManager.getDBinstance().connectApacheDB();
        }
        catch (SQLException sQLException) {
            UctLog.error("SQL Exeception occured while deleting the database. Error: " + sQLException);
        }
    }
}

