/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.ui;

import com.cisco.uct.core.AxlSqlToolkit;
import com.cisco.uct.db.UctDatabaseManager;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.ClusterData;
import com.cisco.uct.utils.Localization;
import com.cisco.uct.utils.PasswordEncryption;
import com.cisco.uct.utils.UctLog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;

public class AddEdit
extends Dialog {
    private Localization localemsg = new Localization();
    private String hostname;
    private String username;
    private String password;
    private String description;
    private char[] chars;
    private String server_down;
    private String login_fail;
    private String success_msg;
    private AxlSqlToolkit ast;
    private static String ccm_version;
    private static String connectionstatus;
    private String db_err;
    private static String prevusername;
    private static String prevpassword;
    private JLabel Password;
    private JPanel addedit;
    private JButton addeditCancel;
    private JButton addeditOK;
    private JSeparator addeditSeparator;
    private JLabel contextErrorLabel;
    private JLabel hostName;
    private JTextField hostNameText;
    private JPasswordField passwordText;
    private JButton testConnection;
    private JLabel ucmDescription;
    private JTextField ucmDescriptionText;
    private JLabel userName;
    private JTextField userNameText;
    private boolean editflag;
    public static boolean testconnection_status;
    String current_hostname;
    private Action enter;
    private Action enter1;
    private Action enter2;

    public AddEdit(Frame frame, boolean bl) {
        super(frame, bl);
        this.server_down = this.localemsg.bundle.getString("UCT.AXL.MESSAGESEND.TEXT");
        this.login_fail = this.localemsg.bundle.getString("UCT.AXL.BADRESPONSE.TEXT");
        this.success_msg = this.localemsg.bundle.getString("UCT.AXL.PASS.TEXT");
        this.ast = new AxlSqlToolkit();
        this.editflag = false;
        this.enter = new AbstractAction(this.localemsg.bundle.getString("UCT.ADDEDIT.TESTCONNECTION.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.testConnectionActionPerformed(actionEvent);
            }
        };
        this.enter1 = new AbstractAction(this.localemsg.bundle.getString("UCT.ADDEDIT.OK.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.addeditOKActionPerformed(actionEvent);
            }
        };
        this.enter2 = new AbstractAction(this.localemsg.bundle.getString("UCT.ADDEDIT.CANCEL.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.addeditCancelActionPerformed(actionEvent);
            }
        };
        this.initComponents();
        this.setTitle(this.localemsg.bundle.getString("UCT.ADDEDIT.ADD.TITLE.TEXT"));
        this.pack();
        this.setLocationRelativeTo(null);
        this.contextErrorLabel.setVisible(false);
        this.userNameText.setText(prevusername);
        this.passwordText.setText(prevpassword);
        this.setVisible(true);
    }

    public AddEdit(JFrame jFrame, boolean bl, ResultSet resultSet, boolean bl2) {
        super((Frame)jFrame, bl);
        this.server_down = this.localemsg.bundle.getString("UCT.AXL.MESSAGESEND.TEXT");
        this.login_fail = this.localemsg.bundle.getString("UCT.AXL.BADRESPONSE.TEXT");
        this.success_msg = this.localemsg.bundle.getString("UCT.AXL.PASS.TEXT");
        this.ast = new AxlSqlToolkit();
        this.editflag = false;
        this.enter = new /* invalid duplicate definition of identical inner class */;
        this.enter1 = new /* invalid duplicate definition of identical inner class */;
        this.enter2 = new /* invalid duplicate definition of identical inner class */;
        this.initComponents();
        this.editflag = bl2;
        String string = null;
        this.hostNameText.setEnabled(false);
        string = this.editCluster(resultSet);
        this.setTitle(this.localemsg.bundle.getString("UCT.ADDEDIT.EDIT.TITLE.TEXT") + "  " + string);
        this.pack();
        this.setLocationRelativeTo(null);
        this.contextErrorLabel.setVisible(false);
        this.setVisible(true);
    }

    private void initComponents() {
        this.addedit = new JPanel();
        this.hostName = new JLabel();
        this.ucmDescription = new JLabel();
        this.userName = new JLabel();
        this.Password = new JLabel();
        this.hostNameText = new JTextField();
        this.ucmDescriptionText = new JTextField();
        this.userNameText = new JTextField();
        this.testConnection = new JButton();
        this.addeditSeparator = new JSeparator();
        this.addeditOK = new JButton();
        this.addeditCancel = new JButton();
        this.passwordText = new JPasswordField();
        this.contextErrorLabel = new JLabel();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AddEdit.this.closeDialog(windowEvent);
            }
        });
        this.setLayout(new BorderLayout(2, 0));
        this.hostName.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.HOSTNAMEIP.TEXT"));
        this.ucmDescription.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.DESCRIPTION.TEXT"));
        this.userName.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.USERNAME.TEXT"));
        this.Password.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.PASSWORD.TEXT"));
        this.hostNameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AddEdit.this.hostNameTextFocusGained(focusEvent);
            }
        });
        this.ucmDescriptionText.setToolTipText("");
        this.ucmDescriptionText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.ucmDescriptionTextActionPerformed(actionEvent);
            }
        });
        this.ucmDescriptionText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AddEdit.this.ucmDescriptionTextFocusGained(focusEvent);
            }
        });
        this.ucmDescriptionText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                AddEdit.this.ucmDescriptionTextKeyTyped(keyEvent);
            }
        });
        this.userNameText.setToolTipText(this.localemsg.bundle.getString("UCT.ADDEDIT.USERNAME.TOOLTIP.TEXT"));
        this.userNameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AddEdit.this.userNameTextFocusGained(focusEvent);
            }
        });
        this.testConnection.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.TESTCONNECTION.TEXT"));
        this.testConnection.setMnemonic(this.localemsg.bundle.getString("UCT.SHORTCUT.TESTCONNECTION").charAt(1));
        this.testConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.testConnectionActionPerformed(actionEvent);
            }
        });
        this.testConnection.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AddEdit.this.testConnectionKeyPressed(keyEvent);
            }
        });
        this.addeditOK.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.OK.TEXT"));
        this.addeditOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.addeditOKActionPerformed(actionEvent);
            }
        });
        this.addeditOK.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AddEdit.this.addeditOKKeyPressed(keyEvent);
            }
        });
        this.addeditCancel.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.CANCEL.TEXT"));
        this.addeditCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddEdit.this.addeditCancelActionPerformed(actionEvent);
            }
        });
        this.addeditCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                AddEdit.this.addeditCancelKeyPressed(keyEvent);
            }
        });
        this.passwordText.setText("");
        this.passwordText.setToolTipText("");
        this.passwordText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                AddEdit.this.passwordTextFocusGained(focusEvent);
            }
        });
        this.contextErrorLabel.setForeground(new Color(255, 0, 0));
        this.contextErrorLabel.setText(this.localemsg.bundle.getString("UCT.ADDEDIT.ADD.CONTEXTERROR.TEXT"));
        GroupLayout groupLayout = new GroupLayout(this.addedit);
        this.addedit.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addeditSeparator, -1, 464, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(251, Short.MAX_VALUE).addComponent(this.addeditOK).addGap(5, 5, 5).addComponent(this.addeditCancel).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.ucmDescription, -1, -1, Short.MAX_VALUE)).addGroup(groupLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostName, -2, 118, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.userName, -1, -1, Short.MAX_VALUE).addComponent(this.Password, -2, 86, -2))))).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.testConnection, -2, 127, -2).addComponent(this.hostNameText, -2, 116, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.ucmDescriptionText, -2, 207, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.contextErrorLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.passwordText, GroupLayout.Alignment.LEADING).addComponent(this.userNameText, GroupLayout.Alignment.LEADING, -1, 117, Short.MAX_VALUE))).addContainerGap(44, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostName, -2, 40, -2).addComponent(this.hostNameText, -2, -1, -2)).addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ucmDescriptionText, -2, -1, -2).addComponent(this.ucmDescription).addComponent(this.contextErrorLabel)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userName, -2, 25, -2).addComponent(this.userNameText, -2, -1, -2)).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.Password, -2, 27, -2).addComponent(this.passwordText, -2, -1, -2)).addGap(8, 8, 8).addComponent(this.testConnection).addGap(8, 8, 8).addComponent(this.addeditSeparator, -2, 10, -2).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addeditCancel).addComponent(this.addeditOK)).addContainerGap(41, Short.MAX_VALUE)));
        groupLayout.linkSize(1, this.hostNameText, this.passwordText, this.ucmDescriptionText, this.userNameText);
        this.add((Component)this.addedit, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void addeditOKActionPerformed(ActionEvent actionEvent) {
        UserCountUtility.addchng = false;
        UserCountUtility.editchng = false;
        UctLog.info("Checking the connection status");
        int n = 0;
        Object[] objectArray = new String[]{this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.OPTIONSADD.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.OPTIONSEDIT.TEXT")};
        testconnection_status = false;
        int n2 = this.testconnection_cluster();
        if (n2 == 1) {
            String string = this.ast.geterrorMessage();
            ccm_version = null;
            if (string.contains(this.success_msg)) {
                ccm_version = this.ast.parse_response();
            }
            if (ccm_version != null) {
                ccm_version = ccm_version.substring(0, 5);
            }
            if (string.contains(this.success_msg)) {
                UctLog.info("Test Connection successful");
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.SUCCESS.TEXT");
            }
            if (string.contains(this.server_down)) {
                n = JOptionPane.showOptionDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SERVERDOWN.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SERVERDOWN.TITLE.TEXT"), 0, 2, null, objectArray, null);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
                UctLog.info("Test Connection Failed due to server connectivity");
            } else if (string.contains(this.login_fail)) {
                n = JOptionPane.showOptionDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.LOGINFAIL.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.LOGINFAIL.TITLE.TEXT"), 0, 2, null, objectArray, null);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
                UctLog.info("Test Connection Failed due to wrong username/password");
            } else if (string.contains(this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.MSG.TEXT"))) {
                n = JOptionPane.showOptionDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.DIALOG.TEXT"), this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.DIALOG.TITLE.TEXT"), 0, 2, null, objectArray, null);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
                UctLog.info("Test Connection Failed due to the Current version of java being used does not support the ability to connect to this server.");
            }
            if (n == 0) {
                UctLog.info("Saving the cluster details into the database");
                n2 = this.addCluster();
                UctLog.info("Cluster details saved ");
                this.current_hostname = this.hostNameText.getText();
                ccm_version = null;
                connectionstatus = null;
                if (UserCountUtility.generate_report) {
                    UserCountUtility.addchng = true;
                    UserCountUtility.editchng = true;
                }
                if (n2 == 1) {
                    this.dispose();
                }
            }
        }
        UctLog.info("Connection Status check done ");
    }

    private void addeditCancelActionPerformed(ActionEvent actionEvent) {
        this.clear();
        this.dispose();
        UctLog.info("Cancelling the Add/Edit a CM Instance : ");
    }

    private void testConnectionActionPerformed(ActionEvent actionEvent) {
        testconnection_status = false;
        int n = this.testconnection_cluster();
        if (n == 1) {
            String string = this.ast.geterrorMessage();
            ccm_version = null;
            if (string.contains(this.success_msg)) {
                ccm_version = this.ast.parse_response();
            }
            if (ccm_version != null) {
                ccm_version = ccm_version.substring(0, 5);
            }
            if (string.contains(this.server_down)) {
                JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SERVERDOWN.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SERVERDOWN.TESTCONNECTION.TITLE.TEXT"), 0);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
            } else if (string.contains(this.login_fail)) {
                JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.LOGINFAIL.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.LOGINFAIL.TITLE.TEXT"), 0);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
            } else if (string.contains(this.success_msg)) {
                JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SUCCESS.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.SUCCESS.TITLE.TEXT"), 1);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.SUCCESS.TEXT");
            } else if (string.contains(this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.MSG.TEXT"))) {
                JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.DIALOG.TEXT"), this.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.DIALOG.TITLE.TEXT"), 0);
                connectionstatus = this.localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
            }
        }
    }

    private void ucmDescriptionTextActionPerformed(ActionEvent actionEvent) {
        String string = this.ucmDescriptionText.getText();
        int n = string.length();
        if (n > 40) {
            this.ucmDescriptionText.setEditable(false);
            this.contextErrorLabel.setVisible(true);
        }
    }

    private void hostNameTextFocusGained(FocusEvent focusEvent) {
        this.hostNameText.selectAll();
    }

    private void ucmDescriptionTextFocusGained(FocusEvent focusEvent) {
        this.ucmDescriptionText.selectAll();
    }

    private void userNameTextFocusGained(FocusEvent focusEvent) {
        this.userNameText.selectAll();
    }

    private void passwordTextFocusGained(FocusEvent focusEvent) {
        this.passwordText.selectAll();
    }

    private void ucmDescriptionTextKeyTyped(KeyEvent keyEvent) {
        String string = this.ucmDescriptionText.getText();
        int n = string.length();
        if (n >= 40) {
            this.ucmDescriptionText.setEditable(false);
            this.contextErrorLabel.setVisible(true);
        }
    }

    private void testConnectionKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.testConnection.addActionListener(this.enter);
        }
        this.testConnection.setAction(this.enter);
        this.testConnection.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.ENTER.EVENT")), keyEvent);
        this.testConnection.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.SPACE.EVENT")), keyEvent);
        this.testConnection.getActionMap().put(keyEvent, this.enter);
    }

    private void addeditOKKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.addeditOK.addActionListener(this.enter1);
        }
        this.addeditOK.setAction(this.enter1);
        this.addeditOK.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.ENTER.EVENT")), keyEvent);
        this.addeditOK.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.SPACE.EVENT")), keyEvent);
        this.addeditOK.getActionMap().put(keyEvent, this.enter1);
    }

    private void addeditCancelKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.addeditCancel.addActionListener(this.enter2);
        }
        this.addeditCancel.setAction(this.enter2);
        this.addeditCancel.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.ENTER.EVENT")), keyEvent);
        this.addeditCancel.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.SPACE.EVENT")), keyEvent);
        this.addeditCancel.getActionMap().put(keyEvent, this.enter2);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){
            Frame frm = new Frame();
            AddEdit dialog = new AddEdit(this.frm, true);

            @Override
            public void run() {
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        frm.dispose();
                        dialog.dispose();
                        System.exit(0);
                    }
                });
                this.dialog.setVisible(true);
            }
        });
    }

    private String editCluster(ResultSet resultSet) {
        UctLog.info("Editing the cluster ");
        try {
            while (resultSet.next()) {
                this.hostname = resultSet.getString("hostname");
                this.username = resultSet.getString("username");
                this.password = resultSet.getString("password");
                this.description = resultSet.getString("description");
                PasswordEncryption passwordEncryption = new PasswordEncryption();
                String string = passwordEncryption.decryptAXL(this.password);
                this.hostNameText.setText(this.hostname);
                this.ucmDescriptionText.setText(this.description);
                this.passwordText.setText(string);
                this.userNameText.setText(this.username);
            }
        }
        catch (Exception exception) {
            UctLog.error("Exception occured while editing the cluster. Error: " + exception);
        }
        return this.hostname;
    }

    private int addCluster() {
        this.hostname = this.hostNameText.getText();
        this.username = this.userNameText.getText();
        this.chars = this.passwordText.getPassword();
        this.password = new String(this.chars);
        this.description = this.ucmDescriptionText.getText();
        prevusername = this.username;
        prevpassword = this.password;
        UctLog.info("Calling a setter getter methods to set the values :");
        PasswordEncryption passwordEncryption = new PasswordEncryption();
        String string = passwordEncryption.encryptAXL(this.password);
        ClusterData clusterData = new ClusterData(this.hostname, this.username, string, this.description, ccm_version, connectionstatus);
        UctDatabaseManager uctDatabaseManager = new UctDatabaseManager();
        if (!this.editflag) {
            UctLog.info("Saving the details in the database for the cluster " + this.hostname);
            this.db_err = uctDatabaseManager.saveCluster(clusterData);
        } else {
            UctLog.info("Updating the details in the database for the cluster " + this.hostname);
            uctDatabaseManager.updateCluster(clusterData, false);
        }
        if (this.db_err != null) {
            if (this.db_err.contains("duplicate key value in a unique or primary key")) {
                JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.DUPLICATE.TEXT"), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.DUPLICATE.TITLE.TEXT"), 0);
                UctLog.info("Can not add the duplicate cluster " + this.hostname);
            }
            return 0;
        }
        return 1;
    }

    private void clear() {
        this.hostNameText.setText("");
        this.ucmDescriptionText.setText("");
        this.passwordText.setText("");
        this.userNameText.setText("");
    }

    private int testconnection_cluster() {
        testconnection_status = true;
        Cursor cursor = new Cursor(3);
        this.setCursor(cursor);
        String[] stringArray = new String[5];
        ArrayList<String> arrayList = new ArrayList<String>();
        stringArray[0] = "-username=" + this.userNameText.getText();
        this.chars = this.passwordText.getPassword();
        this.password = new String(this.chars);
        ccm_version = null;
        connectionstatus = null;
        stringArray[1] = "-password=" + this.password;
        stringArray[2] = "-host=" + this.hostNameText.getText();
        stringArray[3] = "-input=" + UserCountUtility.home_dir + "//src/conf/test.xml";
        stringArray[4] = "-output1=" + UserCountUtility.home_dir + "//dist/sample.response";
        if (this.userNameText.getText().equals("") || this.hostNameText.getText().equals("") || this.password.equals("")) {
            if (this.hostNameText.getText().equals("")) {
                arrayList.add(" " + this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.FIELD1.TEXT") + "\n");
            }
            if (this.userNameText.getText().equals("")) {
                if (this.hostNameText.getText().equals("")) {
                    arrayList.add(this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.FIELD2.TEXT") + "\n");
                } else {
                    arrayList.add(" " + this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.FIELD2.TEXT") + "\n");
                }
            }
            if (this.password.equals("")) {
                arrayList.add(this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.FIELD3.TEXT") + "\n");
            }
            JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.TEXT") + arrayList.toString().replace(",", "").replace("[", "").replace("]", ""), this.localemsg.bundle.getString("UCT.ADDEDIT.DIALOG.MANDATORY.TITLE.TEXT"), 0);
            this.setCursor(Cursor.getDefaultCursor());
            return 0;
        }
        UctLog.info("Getting the Connection status for the cluster " + this.hostNameText.getText());
        AxlSqlToolkit.AXL_main(stringArray);
        this.setCursor(Cursor.getDefaultCursor());
        return 1;
    }

    static {
        prevusername = null;
        prevpassword = null;
        testconnection_status = false;
    }
}

