/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.ui;

import com.cisco.uct.core.AxlSqlToolkit;
import com.cisco.uct.core.LicenseCount;
import com.cisco.uct.core.ParseAxlLicenseResponse;
import com.cisco.uct.db.UctDatabaseManager;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.ClusterData;
import com.cisco.uct.utils.Localization;
import com.cisco.uct.utils.PasswordEncryption;
import com.cisco.uct.utils.UctLog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class RunReport
extends Dialog {
    private Localization localemsg = new Localization();
    private String PASS;
    boolean cancelbutton;
    private Connection dbConnection;
    private JButton cancelButton;
    private JLabel reportLabel;
    private JPanel reportPanel;
    private JProgressBar reportProgress;
    private Action enterrun;

    public RunReport(Frame frame, ArrayList arrayList, boolean bl) {
        super(frame, bl);
        this.PASS = this.localemsg.bundle.getString("UCT.AXL.PASS.TEXT");
        this.cancelbutton = false;
        this.dbConnection = null;
        this.enterrun = new AbstractAction(this.localemsg.bundle.getString("UCT.RUNREPORTUI.CANCELBUTTON.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunReport.this.cancelButtonActionPerformed(actionEvent);
            }
        };
        this.cancelbutton = false;
        UctDatabaseManager uctDatabaseManager = new UctDatabaseManager();
        this.dbConnection = uctDatabaseManager.connectApacheDB();
        this.initComponents();
        this.Process(arrayList);
        this.reportProgress.setStringPainted(true);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initComponents() {
        this.reportPanel = new JPanel();
        this.reportLabel = new JLabel();
        this.cancelButton = new JButton();
        this.reportProgress = new JProgressBar();
        this.setResizable(false);
        this.setUndecorated(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RunReport.this.closeDialog(windowEvent);
            }
        });
        this.reportPanel.setBorder(BorderFactory.createEtchedBorder());
        this.reportLabel.setText(this.localemsg.bundle.getString("UCT.RUNREPORTUI.TEXT"));
        this.cancelButton.setText(this.localemsg.bundle.getString("UCT.RUNREPORTUI.CANCELBUTTON.TEXT"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RunReport.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                RunReport.this.cancelButtonKeyPressed(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.reportPanel);
        this.reportPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(184, 184, 184).addComponent(this.cancelButton)).addGroup(groupLayout.createSequentialGroup().addGap(108, 108, 108).addComponent(this.reportProgress, -2, 230, -2))).addContainerGap(109, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap(139, Short.MAX_VALUE).addComponent(this.reportLabel, -2, 298, -2).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.reportLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reportProgress, -2, 21, -2).addGap(20, 20, 20).addComponent(this.cancelButton).addContainerGap(22, Short.MAX_VALUE)));
        this.add((Component)this.reportPanel, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        UctLog.info("Canceling the Run Report");
        this.cancelbutton = true;
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.cancelButton.addActionListener(this.enterrun);
        }
        this.cancelButton.setAction(this.enterrun);
        this.cancelButton.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.ENTER.EVENT")), keyEvent);
        this.cancelButton.getInputMap().put(KeyStroke.getKeyStroke(this.localemsg.bundle.getString("UCT.ACTION.SPACE.EVENT")), keyEvent);
        this.cancelButton.getActionMap().put(keyEvent, this.enterrun);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){
            Frame frm = new Frame();
            RunReport dialog = new RunReport(this.frm, new ArrayList(), true);

            @Override
            public void run() {
                this.dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        frm.dispose();
                        dialog.dispose();
                        System.exit(0);
                    }
                });
                this.dialog.setVisible(true);
            }
        });
    }

    private void deleteFiles() {
        UctLog.info("Deleting the response files");
        File file = new File(UserCountUtility.home_dir + "//dist/");
        String[] stringArray = file.list();
        if (stringArray == null) {
            UctLog.info("No temporary files");
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (string.indexOf("sample") <= -1) continue;
                String string2 = UserCountUtility.home_dir + "//dist/" + string;
                File file2 = new File(string2);
                file2.delete();
            }
            UctLog.info("Response files deleted");
        }
    }

    private void deleteTempData() {
        try {
            Statement statement = null;
            String string = "DELETE from tempusage";
            UctLog.info("Deleting the data from Temusage");
            statement = this.dbConnection.createStatement();
            statement.executeUpdate(string);
            UctLog.info("Data deleted from Temusage");
            UctLog.info("Deleting the data from Licensecount");
            string = "DELETE from LICENSECOUNT";
            statement.executeUpdate(string);
            UctLog.info("Data deleted from Licensecount");
            this.dbConnection.close();
            UctLog.info("DB Connection closed");
        }
        catch (Exception exception) {
            UctLog.error("SQL Exception occured while deleting the temp data. Error: " + exception.getMessage());
        }
    }

    private void Process(final ArrayList arrayList) {
        final ArrayList arrayList2 = new ArrayList(arrayList);
        final AxlSqlToolkit axlSqlToolkit = new AxlSqlToolkit();
        UctLog.info("Generating the license report ");
        new Thread(new Runnable(){

            @Override
            public void run() {
                int n;
                block9: {
                    UctLog.info("Deleting the previous response files present");
                    RunReport.this.deleteFiles();
                    UctLog.info("Deleting the tempory tables data :");
                    RunReport.this.deleteTempData();
                    boolean bl = true;
                    ArrayList arrayList3 = new ArrayList();
                    while (true) {
                        for (n = 0; n < arrayList.size() && !RunReport.this.cancelbutton; ++n) {
                            UctLog.info("Getting the connection status for the clutser " + arrayList.get(n));
                            RunReport.this.reportProgress.setValue(1);
                            bl = this.AXLquery(axlSqlToolkit, arrayList.get(n).toString());
                            UctLog.info("Starting progress bar based on the AXL connection status :");
                            final int n2 = (n + 1) * 100 / arrayList.size();
                            RunReport.this.reportLabel.setText(MessageFormat.format(((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORTUI.TEXT1"), n + 1, arrayList.size()));
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    RunReport.this.reportProgress.setValue(n2);
                                }
                            });
                            if (bl) continue;
                            UctLog.info("AXL response failed for the cluster" + arrayList.get(n));
                            arrayList3.add(arrayList.get(n));
                        }
                        if (RunReport.this.cancelbutton) break;
                        if (arrayList3.isEmpty()) {
                            UctLog.info("Proceed to generate report");
                        } else {
                            UctLog.info("Failed connections. Pop up a dialog box.");
                            n = this.showDialog(arrayList3) ? 1 : 0;
                            if (n == 0) {
                                arrayList.clear();
                                arrayList.addAll(arrayList3);
                                arrayList3.clear();
                                continue;
                            }
                        }
                        break block9;
                        break;
                    }
                    UctLog.info("Canceling the Run Report");
                }
                if (!RunReport.this.cancelbutton) {
                    UctLog.info("Generating Usage Report");
                    RunReport.this.reportLabel.setText(((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.GENERATEREPORT.TEXT"));
                    UctLog.info("GeneratingLicense  Report Start");
                    for (n = 0; n < arrayList2.size(); ++n) {
                        String string = arrayList2.get(n).toString();
                        final int n3 = (n + 1) * 100 / arrayList2.size();
                        new ParseAxlLicenseResponse(string);
                        LicenseCount licenseCount = new LicenseCount();
                        licenseCount.userlicenseCount(string);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RunReport.this.reportProgress.setValue(n3);
                            }
                        });
                    }
                    UctLog.info("Generating License Report End");
                    RunReport.this.deleteFiles();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        UctLog.error("Exception occured in Thread while running the Report. Error: " + interruptedException.getMessage());
                    }
                }
                RunReport.this.dispose();
            }

            private boolean AXLquery(AxlSqlToolkit axlSqlToolkit2, String string) {
                String[] stringArray;
                Object object;
                ResultSet resultSet;
                UctDatabaseManager uctDatabaseManager = new UctDatabaseManager();
                boolean bl = false;
                String string2 = null;
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                PasswordEncryption passwordEncryption = new PasswordEncryption();
                try {
                    resultSet = uctDatabaseManager.searchCluster(string);
                    while (resultSet.next()) {
                        string2 = resultSet.getString("hostname");
                        string3 = resultSet.getString("username");
                        string4 = resultSet.getString("password");
                        string8 = passwordEncryption.decryptAXL(string4);
                        string6 = resultSet.getString("description");
                    }
                    object = new String[]{"-username=" + string3, "-password=" + string8, "-host=" + string2, "-input=" + UserCountUtility.home_dir + "//src/conf/test.xml", "-output1=" + UserCountUtility.home_dir + "//dist/sample.response"};
                    AxlSqlToolkit.AXL_main(object);
                    string5 = axlSqlToolkit2.parse_response();
                    if (string5 != null) {
                        string5 = string5.substring(0, 5);
                        string7 = ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.AXL.SUCCESS.TEXT");
                        UctLog.info("Connection successful for the cluster " + string2);
                    } else {
                        string7 = ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.AXL.FAILED.TEXT");
                        UctLog.info("Connection failed for the cluster " + string2);
                    }
                    stringArray = new ClusterData(string2, string3, string4, string6, string5, string7);
                    uctDatabaseManager.updateCluster((ClusterData)stringArray, true);
                    resultSet.close();
                }
                catch (Exception exception) {
                    UctLog.error("Error occured while geting the connection status. Error: " + exception.getMessage());
                }
                try {
                    resultSet = uctDatabaseManager.searchCluster(string);
                    while (resultSet.next()) {
                        string2 = resultSet.getString("hostname");
                        string3 = resultSet.getString("username");
                        string4 = resultSet.getString("password");
                        string8 = passwordEncryption.decryptAXL(string4);
                        string5 = resultSet.getString("version");
                    }
                    resultSet.close();
                    object = null;
                    object = string5.charAt(0) == '5' ? "-input=" + UserCountUtility.home_dir + "//src/conf/sample5_x.xml" : "-input=" + UserCountUtility.home_dir + "//src/conf/sample.xml";
                    stringArray = new String[]{"-username=" + string3, "-password=" + string8, "-host=" + string2, object, "-output1=" + UserCountUtility.home_dir + "//dist/" + string2 + "sample1.response", "-output2=" + UserCountUtility.home_dir + "//dist/" + string2 + "sample2.response"};
                    UctLog.info("Sending AXL request to get Licensing details for the cluster" + string2);
                    AxlSqlToolkit.AXL_main(stringArray);
                    String string9 = axlSqlToolkit2.geterrorMessage();
                    if (string9.contains(RunReport.this.PASS)) {
                        UctLog.info("AXL response recieved for the cluster" + string2);
                        bl = true;
                    }
                }
                catch (Exception exception) {
                    UctLog.error("Exception occured while sending the AXL query. Error: " + exception.getMessage());
                }
                return bl;
            }

            private boolean showDialog(ArrayList arrayList3) {
                String string = ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.DIALOG.FAILEDMESSAGE1.TEXT") + arrayList3.toString().replace("[", "").replace("]", "") + ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.DIALOG.FAILEDMESSAGE2.TEXT");
                JFrame jFrame = new JFrame();
                Object[] objectArray = new String[]{((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.DIALOG.OPTION.RETRY.TEXT"), ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.DIALOG.OPTION.GENERATEREPORT.TEXT")};
                int n = JOptionPane.showOptionDialog(jFrame, string, ((RunReport)RunReport.this).localemsg.bundle.getString("UCT.RUNREPORT.DIALOG.FAILEDMESSAGE.TITLE.TEXT"), 0, 2, null, objectArray, objectArray[0]);
                return n != 0;
            }
        }).start();
    }
}

