/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.ui;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UcmComplianceChecker {
    private static String[] sLicenseDef = new String[]{"UCM_CUWLProfessional", "1", "70", "17", "UCM_CUWLStandard", "1", "50", "11", "UCM_EnhancedPlus", "1", "40", "9", "UCM_Enhanced", "1", "30", "6", "UCM_Basic", "1", "20", "4", "UCM_Essential", "1", "10", "0", "UCM_TelepresenceRoom", "0", "0", "11"};
    private Map<String, List<LicenseEntity>> mLicEntityGrpMap = new HashMap<String, List<LicenseEntity>>();
    private Map<String, LicenseEntity> mLicEntityNameMap = new HashMap<String, LicenseEntity>();
    private List<String> mViolatedLicenseList = new ArrayList<String>();
    private List<String> mExternalLicTypeList = new ArrayList<String>();

    public UcmComplianceChecker() {
        this.initialize();
    }

    public List<String> getLicenseTypes() {
        return this.mExternalLicTypeList;
    }

    public int getDLUPerLicense(String string) {
        int n = -1;
        LicenseEntity licenseEntity = this.mLicEntityNameMap.get(string);
        if (licenseEntity != null) {
            n = licenseEntity.getDlu();
        }
        return n;
    }

    public void setLicenseData(String string, int n, int n2) {
        LicenseEntity licenseEntity = this.mLicEntityNameMap.get(string);
        if (licenseEntity != null) {
            licenseEntity.setData(n, n2);
        }
    }

    public boolean doComplianceCheck() {
        this.mViolatedLicenseList.clear();
        boolean bl = true;
        boolean bl2 = true;
        List<LicenseEntity> list = null;
        Set<String> set = this.mLicEntityGrpMap.keySet();
        for (String string : set) {
            list = this.mLicEntityGrpMap.get(string);
            if (list == null) continue;
            bl2 = "0".equals(string) ? this.doNonSubstitutionCheck(list) : this.doSubstitutionCheck(list);
            bl = bl2 && bl;
        }
        return bl;
    }

    public List<String> getViolations() {
        return this.mViolatedLicenseList;
    }

    public Map<String, Integer> getEntitlementData() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Set<String> set = this.mLicEntityNameMap.keySet();
        for (String string : set) {
            LicenseEntity licenseEntity = this.mLicEntityNameMap.get(string);
            int n = licenseEntity.getPlanned();
            if (n <= 0) continue;
            hashMap.put(string, n);
        }
        return hashMap;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("\nTierGroup=1 --- ");
        List<LicenseEntity> list = this.mLicEntityGrpMap.get("1");
        for (LicenseEntity licenseEntity : list) {
            stringBuilder.append("\n");
            stringBuilder.append(licenseEntity.toString());
        }
        stringBuilder.append("\n\nTierGroup=2 --- ");
        list = this.mLicEntityGrpMap.get("2");
        for (LicenseEntity licenseEntity : list) {
            stringBuilder.append("\n");
            stringBuilder.append(licenseEntity.toString());
        }
        stringBuilder.append("\n\nNon-Tiered --- ");
        list = this.mLicEntityGrpMap.get("0");
        for (LicenseEntity licenseEntity : list) {
            stringBuilder.append("\n");
            stringBuilder.append(licenseEntity.toString());
        }
        return stringBuilder.toString();
    }

    private void initialize() {
        int n = 0;
        while (n + 3 < sLicenseDef.length) {
            String string = sLicenseDef[n];
            String string2 = sLicenseDef[n + 1];
            int n2 = Integer.parseInt(sLicenseDef[n + 2]);
            int n3 = Integer.parseInt(sLicenseDef[n + 3]);
            LicenseEntity licenseEntity = new LicenseEntity(string, string2, n2, n3);
            this.mLicEntityNameMap.put(string, licenseEntity);
            this.mExternalLicTypeList.add(string);
            string2 = licenseEntity.getTierGrpId();
            List<LicenseEntity> list = this.mLicEntityGrpMap.get(string2);
            if (list == null) {
                list = new ArrayList<LicenseEntity>();
                this.mLicEntityGrpMap.put(string2, list);
            }
            list.add(licenseEntity);
            n += 4;
        }
    }

    private boolean doNonSubstitutionCheck(List<LicenseEntity> list) {
        if (list == null) {
            return true;
        }
        boolean bl = true;
        for (LicenseEntity licenseEntity : list) {
            licenseEntity.reset();
            if (licenseEntity.isCompliant()) continue;
            this.mViolatedLicenseList.add(licenseEntity.getSummaryData());
            bl = false;
        }
        return bl;
    }

    private boolean doSubstitutionCheck(List<LicenseEntity> list) {
        boolean bl = true;
        if (list == null) {
            return true;
        }
        this.sortLicDefList(list);
        for (LicenseEntity licenseEntity : list) {
            licenseEntity.reset();
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            LicenseEntity licenseEntity = list.get(i);
            if (licenseEntity.isCompliant()) continue;
            for (int j = i - 1; !licenseEntity.isCompliant() && j >= 0; --j) {
                LicenseEntity licenseEntity2 = list.get(j);
                int n2 = licenseEntity2.doLoanOut(licenseEntity.getOverage());
                licenseEntity.doBorrow(n2);
            }
            if (licenseEntity.isCompliant()) continue;
            this.mViolatedLicenseList.add(licenseEntity.getSummaryData());
            bl = false;
        }
        return bl;
    }

    private void sortLicDefList(List<LicenseEntity> list) {
        Collections.sort(list, new Comparator<LicenseEntity>(){

            @Override
            public int compare(LicenseEntity licenseEntity, LicenseEntity licenseEntity2) {
                if (licenseEntity.getTier() < licenseEntity2.getTier()) {
                    return 1;
                }
                if (licenseEntity.getTier() > licenseEntity2.getTier()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public static void main(String[] stringArray) {
        int n = 1;
        UcmComplianceChecker ucmComplianceChecker = new UcmComplianceChecker();
        List<String> list = ucmComplianceChecker.getLicenseTypes();
        System.out.println("\nLicense Types:  ");
        for (String object : list) {
            System.out.println("    " + object);
        }
        System.out.println("\nEnter license data or \"done\" when finished.");
        while (true) {
            System.out.println("Run: " + n++ + " -------");
            UcmComplianceChecker.getUserInput(ucmComplianceChecker);
            if (ucmComplianceChecker.doComplianceCheck()) {
                System.out.println("\nCompliance check - Passed");
            } else {
                System.out.println("\nCompliance check - Failed");
                List<String> list2 = ucmComplianceChecker.getViolations();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String[] stringArray2 = string.split(":");
                    System.out.println("    You require " + stringArray2[1] + " " + stringArray2[0] + " licenses, but only have " + stringArray2[2] + " available.");
                }
            }
            System.out.println("--------------\n");
            ucmComplianceChecker = new UcmComplianceChecker();
        }
    }

    private static void getUserInput(UcmComplianceChecker ucmComplianceChecker) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        String string = "";
        while (true) {
            try {
                while (true) {
                    System.out.print("   Enter - LicType,Required,Planned: ");
                    string = bufferedReader.readLine();
                    if ("done".equalsIgnoreCase(string)) {
                        return;
                    }
                    String[] stringArray = string.split(",");
                    if (stringArray.length < 3) {
                        System.out.println("Insufficient input - retry ...");
                        continue;
                    }
                    String string2 = stringArray[0];
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    ucmComplianceChecker.setLicenseData(string2, n, n2);
                }
            }
            catch (Exception exception) {
                System.out.println("Wrong input - retry ...");
                continue;
            }
            break;
        }
    }

    private class LicenseEntity {
        private String mName;
        private String mTierGrpId;
        private int mTier = 0;
        private int mDlu = 1;
        private int mRequired = 0;
        private int mPlanned = 0;
        private int mBorrowed = 0;
        private int mLoanedOut = 0;

        public LicenseEntity(String string, String string2, int n, int n2) {
            this.mName = string;
            this.mTierGrpId = string2;
            this.mTier = n;
            this.mDlu = n2;
        }

        public String getName() {
            return this.mName;
        }

        public int getPlanned() {
            return this.mPlanned;
        }

        public int getDlu() {
            return this.mDlu;
        }

        public String getTierGrpId() {
            return this.mTierGrpId;
        }

        public int getTier() {
            return this.mTier;
        }

        public void setData(int n, int n2) {
            this.mRequired = n;
            this.mPlanned = n2;
            this.reset();
        }

        public void reset() {
            this.mBorrowed = 0;
            this.mLoanedOut = 0;
        }

        public boolean isCompliant() {
            boolean bl = true;
            if (this.getOverage() > 0) {
                bl = false;
            }
            return bl;
        }

        public int doLoanOut(int n) {
            int n2 = this.mPlanned + this.mBorrowed - (this.mRequired + this.mLoanedOut);
            if (n2 <= 0) {
                return 0;
            }
            int n3 = n;
            if (n2 < n) {
                n3 = n2;
            }
            this.mLoanedOut += n3;
            return n3;
        }

        public void doBorrow(int n) {
            this.mBorrowed += n;
        }

        public int getOverage() {
            int n = 0;
            int n2 = this.getAvailableForUse();
            if (n2 < this.mRequired) {
                n = this.mRequired - n2;
            }
            return n;
        }

        public int getAvailableForUse() {
            return this.mPlanned + this.mBorrowed - this.mLoanedOut;
        }

        public String getSummaryData() {
            return this.mName + ":" + this.mRequired + ":" + this.getAvailableForUse();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Lic: ");
            stringBuilder.append(this.mName);
            stringBuilder.append(", Req=");
            stringBuilder.append(this.mRequired);
            stringBuilder.append(", Adj=");
            stringBuilder.append(this.mPlanned);
            stringBuilder.append(", Bor=");
            stringBuilder.append(this.mBorrowed);
            stringBuilder.append(", Lon=");
            stringBuilder.append(this.mLoanedOut);
            stringBuilder.append(", Ovr=");
            stringBuilder.append(this.getOverage());
            return stringBuilder.toString();
        }
    }
}

