/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.core;

import com.cisco.uct.ui.AddEdit;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.Localization;
import com.cisco.uct.utils.UctLog;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Authenticator;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;

public class AxlSqlToolkit {
    private SOAPConnection con;
    private String port = "8443";
    private static String host;
    private static String username;
    private static String password;
    private String outputFile1;
    private String outputFile2;
    private String inputFile;
    private int queryCount = 0;
    private String currentStatement = null;
    private static String errorMessage;
    private String s_version;
    private static Localization localemsg;

    private void init() {
        try {
            UctLog.info("Initializing the SOAP connection");
            MyTrustManager myTrustManager = new MyTrustManager();
            TrustManager[] trustManagerArray = new TrustManager[]{myTrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            SOAPConnectionFactory sOAPConnectionFactory = SOAPConnectionFactory.newInstance();
            this.con = sOAPConnectionFactory.createConnection();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory);
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession sSLSession) {
                    return true;
                }
            });
            Authenticator.setDefault(new Authenticator(){});
        }
        catch (Exception exception) {
            UctLog.error("Exception while initializing the SOAP connection :  " + exception.getMessage());
        }
    }

    public static String convertSOAPtoString(SOAPMessage sOAPMessage) throws Exception {
        Source source = sOAPMessage.getSOAPPart().getContent();
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult();
        streamResult.setOutputStream(byteArrayOutputStream);
        transformer.transform(source, streamResult);
        return byteArrayOutputStream.toString().trim();
    }

    public SOAPMessage createSqlMessage(String string, String string2) throws Exception {
        MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage sOAPMessage = messageFactory.createMessage();
        SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
        SOAPBody sOAPBody = sOAPEnvelope.getBody();
        SOAPBodyElement sOAPBodyElement = sOAPBody.addBodyElement(sOAPEnvelope.createName(string));
        sOAPBodyElement.addAttribute(sOAPEnvelope.createName("sequence"), String.valueOf(System.currentTimeMillis()));
        sOAPBodyElement.addChildElement("sql").addTextNode(string2);
        return sOAPMessage;
    }

    public String getUrlEndpoint() {
        return new String("https://" + username + ":" + password + "@" + host + ":" + this.port + "/axl/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SOAPMessage sendMessage(SOAPMessage sOAPMessage) throws Exception {
        SOAPMessage sOAPMessage2 = null;
        FileWriter fileWriter = this.queryCount == 2 ? new FileWriter(this.outputFile2, true) : new FileWriter(this.outputFile1, true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        try {
            UctLog.info("Sending SOAP message");
            sOAPMessage2 = this.con.call(sOAPMessage, (Object)this.getUrlEndpoint());
            if (sOAPMessage2 != null) {
                SOAPPart sOAPPart = sOAPMessage2.getSOAPPart();
                SOAPEnvelope sOAPEnvelope = sOAPPart.getEnvelope();
                SOAPBody sOAPBody = sOAPEnvelope.getBody();
                if (sOAPBody.hasFault()) {
                    UctLog.error(sOAPBody.getFault().getFaultString());
                } else {
                    UctLog.info("SOAP message recieved");
                    this.seterrorMessage(AxlSqlToolkit.localemsg.bundle.getString("UCT.AXL.PASS.TEXT"));
                }
                bufferedWriter.write(AxlSqlToolkit.convertSOAPtoString(sOAPMessage2));
                bufferedWriter.newLine();
                bufferedWriter.flush();
                bufferedWriter.close();
                fileWriter.close();
            } else {
                UctLog.info("No reply was received");
                this.seterrorMessage(AxlSqlToolkit.localemsg.bundle.getString("UCT.AXL.NOREPLY.TEXT"));
            }
        }
        catch (Exception exception) {
            UctLog.error("Error occured while sending the soap message due to" + exception.getMessage());
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            if (stringWriter.toString().contains(AxlSqlToolkit.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.TEXT"))) {
                if (AddEdit.testconnection_status) {
                    this.seterrorMessage(AxlSqlToolkit.localemsg.bundle.getString("UCT.AXL.JREPROBLEM.MSG.TEXT"));
                }
                UctLog.error("The Current version of java being used does not support the ability to connect to version 8.6 Unifed CM servers");
            } else {
                this.seterrorMessage(exception.getMessage());
            }
        }
        finally {
            fileWriter.close();
            bufferedWriter.close();
            AddEdit.testconnection_status = false;
        }
        return sOAPMessage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        try {
            FileInputStream fileInputStream = null;
            try {
                new FileWriter(this.outputFile1).close();
                if (this.outputFile2 != null) {
                    new FileWriter(this.outputFile2).close();
                }
                DOMParser dOMParser = new DOMParser();
                fileInputStream = new FileInputStream(this.inputFile);
                dOMParser.parse(new InputSource(fileInputStream));
                Element element = dOMParser.getDocument().getDocumentElement();
                TreeWalker treeWalker = ((DocumentTraversal)((Object)dOMParser.getDocument())).createTreeWalker(element, 1, new GenericNodeFilter("sql"), true);
                Node node = treeWalker.firstChild();
                while (node != null) {
                    Node node2 = node.getAttributes().getNamedItem("query");
                    Node node3 = node.getAttributes().getNamedItem("update");
                    if (node2 != null) {
                        ++this.queryCount;
                        this.currentStatement = node2.getNodeValue();
                        this.sendMessage(this.createSqlMessage("executeSQLQuery", this.currentStatement));
                    } else if (node3 != null) {
                        this.currentStatement = node3.getNodeValue();
                        this.sendMessage(this.createSqlMessage("executeSQLUpdate", this.currentStatement));
                    } else {
                        UctLog.info("SQL element did not contain a query or update attribute");
                    }
                    node = treeWalker.nextSibling();
                }
            }
            catch (Exception exception) {
                UctLog.error(exception.getMessage());
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            UctLog.error(exception.getMessage());
        }
    }

    public static void AXL_main(String[] stringArray) {
        try {
            localemsg = new Localization();
            AxlSqlToolkit axlSqlToolkit = new AxlSqlToolkit();
            axlSqlToolkit.parseArgs(stringArray);
            axlSqlToolkit.init();
            axlSqlToolkit.execute();
        }
        catch (Exception exception) {
            UctLog.error(exception.getMessage());
        }
    }

    private void parseArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("-username")) {
                username = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            if (stringArray[i].startsWith("-password")) {
                password = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                String string = null;
                if (password.length() > 0) {
                    for (int j = 0; j < password.length(); ++j) {
                        if (password.charAt(j) == '`' || password.charAt(j) == '!' || password.charAt(j) == '@' || password.charAt(j) == '#' || password.charAt(j) == '$' || password.charAt(j) == '%' || password.charAt(j) == '^' || password.charAt(j) == '&' || password.charAt(j) == '(' || password.charAt(j) == ')' || password.charAt(j) == '{' || password.charAt(j) == '}' || password.charAt(j) == '[' || password.charAt(j) == ']' || password.charAt(j) == '|' || password.charAt(j) == '\\' || password.charAt(j) == ';' || password.charAt(j) == '\"' || password.charAt(j) == '\'' || password.charAt(j) == '<' || password.charAt(j) == '>' || password.charAt(j) == '~' || password.charAt(j) == '?' || password.charAt(j) == '/' || password.charAt(j) == ' ') {
                            if (string == null) {
                                string = "%" + AxlSqlToolkit.DeciTohex(password.charAt(j));
                                continue;
                            }
                            string = string + "%" + AxlSqlToolkit.DeciTohex(password.charAt(j));
                            continue;
                        }
                        string = string == null ? Character.toString(password.charAt(j)) : string + password.charAt(j);
                    }
                }
                password = string;
                continue;
            }
            if (stringArray[i].startsWith("-host")) {
                host = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            if (stringArray[i].startsWith("-port")) {
                this.port = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            if (stringArray[i].startsWith("-input")) {
                this.inputFile = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            if (stringArray[i].startsWith("-output1")) {
                this.outputFile1 = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            if (stringArray[i].startsWith("-output2")) {
                this.outputFile2 = stringArray[i].substring(stringArray[i].indexOf("=") + 1, stringArray[i].length());
                continue;
            }
            this.usage();
            System.exit(-1);
        }
    }

    private void usage() {
        System.out.println("AxlTestDriver (Java) parameters and options:");
        System.out.println("  -username=<value>: use the specified username instead of default");
        System.out.println("  -password=<value>: use the specified password instead of default");
        System.out.println("  -host=<hostname or IP>: use the specified hostname");
        System.out.println("  -port=<portnumber>: use the specified portnumber");
        System.out.println("  -input=<filename>: use the specified file as the source of the sql statements");
        System.out.println("  -output=<filename>: use the specified file as the destination of the AXL responses");
    }

    public static String DeciTohex(int n) {
        String string;
        int n2;
        String string2 = "";
        String string3 = "";
        do {
            n2 = n % 16;
            string = AxlSqlToolkit.DtoHex(n2);
            string2 = string2 + string;
        } while ((n /= 16) / 16 != 0);
        n2 = n % 16;
        string = AxlSqlToolkit.DtoHex(n2);
        string2 = string2 + string;
        for (int i = string2.length() - 1; i >= 0; --i) {
            string3 = string3 + string2.charAt(i);
        }
        return string3;
    }

    public static String DtoHex(int n) {
        String string;
        String string2 = string = String.valueOf(n);
        string = string.equals("10") ? "A" : (string.equals("11") ? "B" : (string.equals("12") ? "C" : (string.equals("13") ? "D" : (string.equals("14") ? "E" : (string.equals("15") ? "F" : string2)))));
        return string;
    }

    public String parse_response() {
        this.s_version = null;
        try {
            File file = new File(UserCountUtility.home_dir + "//dist/sample.response");
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("row");
            Node node = nodeList.item(0);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.s_version = this.getTagValue("version", element);
                UctLog.info("The version for the currently added cluster is" + this.s_version + ":");
            }
        }
        catch (Exception exception) {
            UctLog.error("SQL Exception occured while parsing the response during the test connection. Error: " + exception.getMessage());
        }
        return this.s_version;
    }

    private String getTagValue(String string, Element element) {
        NodeList nodeList = element.getElementsByTagName(string).item(0).getChildNodes();
        Node node = nodeList.item(0);
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public String geterrorMessage() {
        return errorMessage;
    }

    public void seterrorMessage(String string) {
        errorMessage = string;
    }

    public class MyTrustManager
    implements X509TrustManager {
        MyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    public class GenericNodeFilter
    implements NodeFilter {
        String theNodeName = null;

        public GenericNodeFilter(String string) {
            this.theNodeName = string;
        }

        @Override
        public short acceptNode(Node node) {
            if (node.getNodeName().equals(this.theNodeName)) {
                return 1;
            }
            return 2;
        }
    }
}

