/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.ui;

import com.cisco.uct.db.UctDatabaseManager;
import com.cisco.uct.ui.JavaSplash;
import com.cisco.uct.ui.UserCountUtility;
import com.cisco.uct.utils.Localization;
import com.cisco.uct.utils.PasswordEncryption;
import com.cisco.uct.utils.UctLog;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class JavaSplashSecond
extends JDialog {
    private Localization localemsg;
    private Action enter;
    private Action enter1;
    private ActionListener listener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JavaSplashSecond.this.submitPasswordActionPerformed(actionEvent);
        }
    };
    private JPanel javaSplashSecondPanel1;
    private JPanel javaSplashSecondPanel2;
    private JPasswordField passwordFieldText;
    private JLabel passwordLabel;
    private JButton secsplashexitButton;
    private JLabel startLabel;
    private JButton startOver;
    private JLabel startOverLabel;
    private JButton submitPassword;

    public JavaSplashSecond(Frame frame, boolean bl) {
        super(frame, bl);
        this.localemsg = new Localization();
        this.initComponents();
        this.setTitle(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.TITLE.TEXT"));
        this.pack();
        this.enter = new AbstractAction(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.SUBMITBUTTON.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaSplashSecond.this.submitPasswordActionPerformed(actionEvent);
            }
        };
        this.enter1 = new AbstractAction(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.STARTOVERBUTTON.TEXT")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaSplashSecond.this.startOverActionPerformed(actionEvent);
            }
        };
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.javaSplashSecondPanel1 = new JPanel();
        this.javaSplashSecondPanel2 = new JPanel();
        this.startLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.submitPassword = new JButton();
        this.startOverLabel = new JLabel();
        this.startOver = new JButton();
        this.passwordFieldText = new JPasswordField();
        this.secsplashexitButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.javaSplashSecondPanel1.setCursor(new Cursor(0));
        this.javaSplashSecondPanel1.setOpaque(false);
        this.startLabel.setFont(new Font(UserCountUtility.font_text, UserCountUtility.font_unbold, UserCountUtility.font_size1));
        this.startLabel.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.MESSAGE.TEXT"));
        this.passwordLabel.setFont(new Font(UserCountUtility.font_text, UserCountUtility.font_unbold, UserCountUtility.font_size1));
        this.passwordLabel.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.PASSWORD.TEXT"));
        this.submitPassword.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.SUBMITBUTTON.TEXT"));
        this.submitPassword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaSplashSecond.this.submitPasswordActionPerformed(actionEvent);
            }
        });
        this.submitPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JavaSplashSecond.this.submitPasswordKeyPressed(keyEvent);
            }
        });
        this.startOverLabel.setFont(new Font(UserCountUtility.font_text, UserCountUtility.font_unbold, UserCountUtility.font_size1));
        this.startOverLabel.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.STARTOVERMESSAGE.TEXT"));
        this.startOver.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.STARTOVERBUTTON.TEXT"));
        this.startOver.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaSplashSecond.this.startOverActionPerformed(actionEvent);
            }
        });
        this.startOver.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JavaSplashSecond.this.startOverKeyPressed(keyEvent);
            }
        });
        this.passwordFieldText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                JavaSplashSecond.this.passwordFieldTextKeyPressed(keyEvent);
            }
        });
        this.secsplashexitButton.setText(this.localemsg.bundle.getString("UCT.SPLASHSCREEN.EXIT.TEXT"));
        this.secsplashexitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JavaSplashSecond.this.secsplashexitButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.javaSplashSecondPanel2);
        this.javaSplashSecondPanel2.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startLabel).addGroup(groupLayout.createSequentialGroup().addComponent(this.passwordLabel).addGap(15, 15, 15).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordFieldText, -2, 139, -2).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.startOverLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.submitPassword, GroupLayout.Alignment.LEADING, -2, 74, -2).addGroup(GroupLayout.Alignment.LEADING, groupLayout.createSequentialGroup().addComponent(this.startOver).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secsplashexitButton)))))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.startLabel).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordFieldText, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.submitPassword).addGap(10, 10, 10).addComponent(this.startOverLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startOver).addComponent(this.secsplashexitButton)).addContainerGap(27, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout(this.javaSplashSecondPanel1);
        this.javaSplashSecondPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaSplashSecondPanel2, -1, -1, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaSplashSecondPanel2, -1, -1, Short.MAX_VALUE));
        GroupLayout groupLayout3 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaSplashSecondPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.javaSplashSecondPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void startOverActionPerformed(ActionEvent actionEvent) {
        this.dispose();
        UctDatabaseManager.getDBinstance().deleteDatabase();
        JavaSplash javaSplash = new JavaSplash((Frame)UserCountUtility.frame, true);
        javaSplash.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        javaSplash.setVisible(true);
    }

    private void submitPasswordActionPerformed(ActionEvent actionEvent) {
        String string;
        char[] cArray = this.passwordFieldText.getPassword();
        if (new String(cArray).equals("")) {
            JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.SPLASHSCREEN.DIALOG.NULLPASSWORDENTER.TEXT"), this.localemsg.bundle.getString("UCT.SPLASHSCREEN.DIALOG.NOPASSWORD.TITLE.TEXT"), 0);
            UctLog.info("Incorrect Password Entered");
            this.passwordFieldText.removeActionListener(this.listener);
            return;
        }
        PasswordEncryption passwordEncryption = new PasswordEncryption(new String(cArray));
        String string2 = passwordEncryption.encryptUCTPassword(new String(cArray));
        if (!string2.equals(string = UctDatabaseManager.getDBinstance().getPassword())) {
            JOptionPane.showMessageDialog(UserCountUtility.frame, this.localemsg.bundle.getString("UCT.SPLASHSCREEN.DIALOG.PASSWORDENTER.CORRECT.TEXT"), this.localemsg.bundle.getString("UCT.SPLASHSCREEN.DIALOG.INCORRECTPASSWORD.TITLE.TEXT"), 0);
            this.passwordFieldText.removeActionListener(this.listener);
            UctLog.info("Incorrect Password Entered");
            this.passwordFieldText.selectAll();
            return;
        }
        UctLog.info("Login Successful");
        this.dispose();
    }

    private void passwordFieldTextKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.passwordFieldText.addActionListener(this.listener);
        }
    }

    private void submitPasswordKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.passwordFieldText.requestFocus();
        }
    }

    private void startOverKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.passwordFieldText.requestFocus();
        }
    }

    private void secsplashexitButtonActionPerformed(ActionEvent actionEvent) {
        UctLog.info("The application has been exited");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaSplashSecond javaSplashSecond = new JavaSplashSecond((Frame)new JFrame(), true);
                javaSplashSecond.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent windowEvent) {
                        System.exit(0);
                    }
                });
                javaSplashSecond.setVisible(true);
            }
        });
    }
}

