/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.uct.utils;

import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.NullEnumeration;

public class UctLog {
    private static Logger sLogger = null;
    private static final String sCallerFQCN = "usercounttool";

    public static boolean isLoggerReady() {
        return sLogger != null;
    }

    public static RollingFileAppender getRollingFileAppender(Category category) {
        if (category != null) {
            Enumeration enumeration = category.getAllAppenders();
            if (enumeration instanceof NullEnumeration) {
                return UctLog.getRollingFileAppender(category.getParent());
            }
            while (enumeration.hasMoreElements()) {
                Appender appender = (Appender)enumeration.nextElement();
                if (!(appender instanceof RollingFileAppender)) continue;
                return (RollingFileAppender)appender;
            }
        }
        return null;
    }

    public static boolean isDebugEnabled() {
        return sLogger != null ? sLogger.isDebugEnabled() : false;
    }

    public static boolean isInfoEnabled() {
        return sLogger != null ? sLogger.isInfoEnabled() : false;
    }

    public static void debug(Object object) {
        if (sLogger != null) {
            sLogger.log((Priority)Level.DEBUG, object, null);
        }
    }

    public static void info(Object object) {
        if (sLogger != null) {
            sLogger.log((Priority)Level.INFO, object, null);
        }
    }

    public static void warn(Object object) {
        if (sLogger != null) {
            sLogger.log((Priority)Level.WARN, object, null);
        }
    }

    public static void error(Object object) {
        if (sLogger != null) {
            sLogger.log((Priority)Level.ERROR, object, null);
        }
    }

    public static void error(Object object, Exception exception) {
        if (sLogger != null) {
            String string = object + " - " + UctLog.getExceptionStr(exception);
            sLogger.log(sCallerFQCN, (Priority)Level.ERROR, (Object)string, null);
        }
    }

    public static void fatal(Object object) {
        if (sLogger != null) {
            sLogger.log((Priority)Level.FATAL, object, null);
        }
    }

    public static String getExceptionStr(Exception exception) {
        String string = "";
        if (exception != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(exception.toString()).append("\n");
            StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
            for (int i = 0; i < stackTraceElementArray.length; ++i) {
                stringBuilder.append(stackTraceElementArray[i].toString()).append("\n");
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    static {
        sLogger = Logger.getLogger((String)"src.test");
    }
}

