# Script Version: 2.1.2.1
# Script Name: app-b-acd-aa
# April 26, 2004 Satish Ananthanarayana
#
# Copyright (c) 2006 by Cisco Systems, Inc.
# All rights reserved.
#-----------------------------------------------------------
# Modification History:
#
# Modified by: Satish Ananthanarayana
# Modified Date: June 14, 2006
# - Increased initialDigitTimeout to 20 seconds as per
# - SR 603748939
#
# Modified by: Satish Ananthanarayana
# Modified Date: June 02, 2006
# - Removed leg setupack leg_incoming in the act_ISN_Invocation
# - procedure
# - Incorporated fix for CSCsd14220
# - Incorporated fix for CSCsd14234
#
# Modified by: Satish Ananthanarayana
# Modified Date: May 10, 2006
# - Introduced new parameter menu-timeout to connect the user
#   to an operator after this timeout, ie., if user did not
#   select any option even after playing the main menu multiple
#   times = menu-timeout, call will be connected to the operator.
#   A new prompt _bacd_xferto_operator.au has been added. This prompt
#   plays before the call is connected to the operator
# - Incorporated fix for CSCsd18856 
# - Incorporated fix for CSCeh53421 
#
# Modified by: Satish Ananthanarayana
# Modified Date: April 06, 2005
# - Added support to interoperate with ISN Application
# - Incorporated CSCeh53421 fix
#
# Modifed by: Satish Ananthanarayana
# Modified Date: Feb 10, 2005
# - Removed RNA timeout in the script
# - Added support for drop through mode
# - changed the range for call-retry-timer from 5-30 to 1-30
# - changed the default value of call-retry-timer to 5 sec
# - Added handoff string during handoff to call queue
# - Added support for MOH livefeed
#-----------------------------------------------------------
#
# Cisco CME B-ACD Auto Attendant Application
#
#

proc init { } {
	global PARAM
	global PARAM1
	global callInfo

	set PARAM(interruptPrompt) true
	set PARAM(maxDigits) 1
	set PARAM(initialDigitTimeout) 20
	set PARAM(abortKey) *

	set PARAM1(interruptPrompt) true
	set PARAM1(dialPlanTerm) true
	set PARAM1(initialDigitTimeout) 20
	set PARAM1(terminationKey) #
	set PARAM1(abortKey) *

	set callInfo(setupFromBACD) true

}

proc init_ConfigVars { } {
	global destination
	global aaPilot
	global CLI
	global serviceName
	global hString
	global voiceMailDN
	global welcomePrompt
	global dropThroPrompt
	global dropThroOption
	global dialByExtension
	global configFail
	global dropThroMode
	global optionIndex
	global maxExtensionLen
	global isnName

	# aa-pilot is the IVR number configured on the gateway to be used by the customer
	set configFail 0

	if [infotag get cfg_avpair_exists aa-pilot] {
		set aaPilot [string trim [infotag get cfg_avpair aa-pilot]]
	} else {
		set aaPilot "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter aa-pilot does not exist --"
		set configFail 1
		call close
	}
	if [infotag get cfg_avpair_exists service-name] {
		set serviceName [string trim [infotag get cfg_avpair service-name]]
	} else {
		set serviceName "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter service-name does not exist --"
		set configFail 1
		call close
	}	
	if [infotag get cfg_avpair_exists isn-name] {
		set isnName [string trim [infotag get cfg_avpair isn-name]]
		puts -nonewline "TCL AA: --  ISN Application is configured --"
	} else {
		set isnName "NONE"
	}
	if [infotag get cfg_avpair_exists handoff-string] {
		set hString [string trim [infotag get cfg_avpair handoff-string]]
	} else {
		set hString "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter handoff-string does not exist --"
		set configFail 1
		call close
	}	
	if [infotag get cfg_avpair_exists voice-mail] {
		set voiceMailDN [string trim [infotag get cfg_avpair voice-mail]]
	} else {
		set voiceMailDN "NONE"
		puts -nonewline "TCL AA: -- ERROR: Mandatory parameter voice-mail does not exist --"
		set configFail 1
		call close
	}
	if [infotag get cfg_avpair_exists welcome-prompt] {
		set welcomePrompt [string trim [infotag get cfg_avpair welcome-prompt]]
	} else {
		set welcomePrompt "_bacd_welcome.au"
	}
	if [infotag get cfg_avpair_exists drop-through-prompt] {
		set dropThroPrompt [string trim [infotag get cfg_avpair drop-through-prompt]]
	} else {
		set dropThroPrompt "NONE"
	}
	if [infotag get cfg_avpair_exists drop-through-option] {
		set dropThroOption [string trim [infotag get cfg_avpair drop-through-option]]
		set dropThroMode 1
	} else {
		set dropThroOption "NONE"
		set dropThroMode 0
	}
	if [infotag get cfg_avpair_exists dial-by-extension-option] {
		set dialByExtension [string trim [infotag get cfg_avpair dial-by-extension-option]]
	} else {
		set dialByExtension "NONE"
	}
	if [infotag get cfg_avpair_exists max-extension-length] {
		set maxExtensionLen [string trim [infotag get cfg_avpair max-extension-length]]
		if { $maxExtensionLen < 0 } {
			puts -nonewline "TCL AA: -- ERROR: max-extension-length $maxExtensionLen is invalid --"
			set configFail 1
			call close
		}
	} else {
		set maxExtensionLen 5
		puts -nonewline "TCL AA: -- max-extension-length is set to default value of $maxExtensionLen --"
	}
	if [infotag get cfg_avpair_exists option-index] {
		set optionIndex [string trim [infotag get cfg_avpair option-index]]
	} else {
		set optionIndex 0
	}

	# CLI: second-greeting-time (30 - 120) default 60
	set result [init_cfgAvPair second-greeting-time 60 30 120]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter second-greeting-time $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter second-greeting-time $result --"
			puts -nonewline "TCL AA: -- Setting default to 60"
			set CLI(second-greeting-time) 60
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter second-greeting-time\
				= $CLI(second-greeting-time) --"
		}
	}

	# CLI: call-retry-timer (1 - 30) default 5
	set result [init_cfgAvPair call-retry-timer 5 1 30]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter call-retry-timer $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter second-greeting-time $result --"
			puts -nonewline "TCL AA: -- Setting default to 15"
			set CLI(call-retry-timer) 5 
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter call-retry-timer\
				= $CLI(call-retry-timer)  --"
		}
	}

	# CLI: max-time-call-retry (60 - 3600) default 600
	set result [init_cfgAvPair max-time-call-retry 600 60 3600]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter max-time-call-retry $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter max-time-call-retry $result --"
			puts -nonewline "TCL AA: -- Setting default to 600"
			set CLI(max-time-call-retry) 600
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter max-time-call-retry\
				= $CLI(max-time-call-retry)  --"
		}
	}

	# CLI: max-time-vm-retry (1 - 3) default 1
	set result [init_cfgAvPair max-time-vm-retry 1 1 3]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter max-time-vm-retry $result --"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter max-time-vm-retry $result --"
			puts -nonewline "TCL AA: -- Setting default to 1"
			set CLI(max-time-vm-retry) 1
		}
		default {
			puts -nonewline "TCL AA: -- Valid mandatory parameter max-time-vm-retry\
				= $CLI(max-time-vm-retry)  --"
		}
	}
	# CLI: number-of-hunt-grps (1 - 3) default 3
	set result [init_cfgAvPair number-of-hunt-grps 3 1 3]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Mandatory parameter number-of-hunt-grps $result"
			set configFail 1
			call close
		}
		{does not exist} {
			puts -nonewline "TCL AA: -- Mandatory parameter number-of-hunt-grps $result"
			puts -nonewline "TCL AA: -- Setting default to 3"
			set CLI(number-of-hunt-grps) 3
		}
		default {
			puts -nonewline "TCL AA: -- Valid Mandatory parameter number-of-hunt-grps\
			= $CLI(number-of-hunt-grps) --"
		}
	}
	# CLI: menu-timeout (1 - 10) default 3
	set result [init_cfgAvPair menu-timeout 3 1 10]
	switch $result {
		{invalid type} {
			puts -nonewline "TCL AA: -- ERROR: Optional parameter menu-timeout $result"
			set configFail 1
			call close
		}
		{does not exist} {
			set CLI(menu-timeout) "NONE"
		}
		default {
			puts -nonewline "TCL AA: -- Valid optional parameter menu-timeout\
			= $CLI(menu-timeout) --"
		}
	}
}

proc init_cfgAvPair {name default lower upper} {

	global CLI

	if {[infotag get cfg_avpair_exists $name]} {
		set tmpStr [string trim [infotag get cfg_avpair $name]]
		if {[regexp {^([0-9]+)$} $tmpStr d CLI($name)]} {
			if {$CLI($name) < 0} {
				puts -nonewline "TCL AA: -- ERROR: ++ $name is to a negative value ++"
				return "invalid type"
			} elseif {$CLI($name) < $lower} {
				set CLI($name) $lower
				puts -nonewline "TCL AA: ++ $name is set to less than minimum allowed value of $lower ++"
				puts -nonewline "TCL AA: ++ Setting $name to minimum value of $lower ++"
			} elseif {$CLI($name) > $upper} {
				set CLI($name) $upper
				puts -nonewline "TCL AA: ++ $name is set to more than maximum allowed value of $upper ++"
				puts -nonewline "TCL AA: ++ Setting $name to maximum value of $upper ++"
			}
		} else {
			return "invalid type"
		}
	} else {
		return "does not exist"
	}
}


proc init_perCallVars { } {
	puts "\nproc init_perCallvars"
	global ani
	global dnis
	global queueMessage
	global queueID
	global AATIMER
	global callAbandon
	global KATIMER
	global keepAliveTime
	global callCloseFlag 
	global invalidHuntGrp
	global invalidExtension
	global vmStatFlag
	global vmSetupFlag
	global maxVMRetry
	global playMusicFlag
	global optionSelected
	global svcUnavlbl
	global destHunt	
	global callInfo
	global answerTime
	global abandonTime
	global retryMenuFlag 
	global dropThroFlag
	global liveMusicFeed
	global legDisconnectTimer
	global dropAgtFlag
	global retryDigitCollect
	global isnInvokedFlag
	global isnTimeout
	global menuRetry

	set ani ""
	set dnis ""
	set callAbandon 1
	set keepAliveTime 10
	set callCloseFlag 0
	set invalidHuntGrp 0
	set invalidExtension 0
	set vmStatFlag 0
	set vmSetupFlag 0
	set maxVMRetry 0
	set playMusicFlag 0
	set optionSelected 0
	set svcUnavlbl 0
	set destHunt 0
	set answerTime 0
	set abandonTime 0
	set retryMenuFlag 0
	set dropThroFlag 0
	set liveMusicFeed 0
	set legDisconnectTimer 10
	set dropAgtFlag 0
	set retryDigitCollect 1
	set isnInvokedFlag 0
	set isnTimeout 45
	set menuRetry 0

	set ani [infotag get leg_ani]
	set dnis [infotag get leg_dnis]
	set callInfo(originationNum) $ani
	set callInfo(redirectNum) ""
}

proc act_Handoff_Activity { } {
	set isnString [infotag get evt_handoff_string]
	if { ($isnString == "ISN") } {
		puts -nonewline "TCL AA: >>> CME B-ACD AA Application is invoked by ISN Application <<<"
		act_ISN_Invocation
	} else {
		act_Setup
	}
}

proc act_Setup { } {
	global PARAM
	global AATIMER
	global callInfo
	global dnis
	global aaPilot
	global queueID
	global ani
	global serviceName
	global welcomePrompt
	global callCloseFlag
	global configFail
	global CLI
	global hString
	global dropThroMode
	global dropThroPrompt
	global isnInvokedFlag

	set AATIMER(curTime) [clock seconds]

	if { $configFail == 0} {
		init_perCallVars
		infotag set med_language 1
		set queueID [infotag get mod_handle_service B-ACD-SERVICE]
		if {$queueID == "unavailable"} {
			puts -nonewline "TCL AA: +++ B-ACD-SERVICE not registered, Starting B-ACD-SERVICE +++"
			if { $serviceName == "NONE" } {
				puts -nonewline "TCL AA: +++ Unable to start B-ACD-SERVICE,\
					improper application name or no application name configured +++" 
				call close
			} else {
				handoff appl leg_incoming $serviceName -s $hString
				call close
			}
		} elseif { ($dnis == "") || ($dnis == $aaPilot) } {
			if { $isnInvokedFlag == 0 } {
				leg setupack leg_incoming
				leg proceeding leg_incoming
				leg connect leg_incoming
			}
			if { ($CLI(number-of-hunt-grps) == 1) && ($dropThroMode == 1)} {
				if {$dropThroPrompt == "NONE"} {
					act_GotDestNoOption
				} else {
					media play leg_incoming $dropThroPrompt
					puts -nonewline "TCL AA: ++ Playing Drop Through Prompt ++"
					fsm setstate OPTIONSELECTED
				}
			} else {
				leg collectdigits leg_incoming PARAM
				puts -nonewline "TCL AA: ++ Playing Welcome Prompt and options menu ++"
				media play leg_incoming $welcomePrompt %s500 _bacd_options_menu.au
				fsm setstate GETDEST
			}
		} else {
			call close
		}
	} else {
		call close
	}
}

proc act_ISN_Invocation { } {
	global PARAM
	global AATIMER
	global callInfo
	global dnis
	global aaPilot
	global queueID
	global ani
	global serviceName
	global welcomePrompt
	global callCloseFlag
	global configFail
	global CLI
	global hString
	global dropThroMode
	global dropThroPrompt
	global isnInvokedFlag

	set AATIMER(curTime) [clock seconds]

	if { $configFail == 0} {
		init_perCallVars
		infotag set med_language 1
		set isnInvokedFlag 1
		set queueID [infotag get mod_handle_service B-ACD-SERVICE]
		if {$queueID == "unavailable"} {
			puts -nonewline "TCL AA: +++ B-ACD-SERVICE not registered, Starting B-ACD-SERVICE +++"
			if { $serviceName == "NONE" } {
				puts -nonewline "TCL AA: +++ Unable to start B-ACD-SERVICE,\
					improper application name or no application name configured +++" 
				call close
			} else {
				handoff appl leg_all $serviceName -s "$hString ISN"
				call close
			}
		} else { 
			if { ($CLI(number-of-hunt-grps) == 1) && ($dropThroMode == 1)} {
				if {$dropThroPrompt == "NONE"} {
					act_GotDestNoOption
				} else {
					media play leg_incoming $dropThroPrompt
					puts -nonewline "TCL AA: ++ Playing Drop Through Prompt ++"
					fsm setstate OPTIONSELECTED
				}
			} else {
				leg collectdigits leg_incoming PARAM
				puts -nonewline "TCL AA: ++ Playing Welcome Prompt and options menu ++"
				media play leg_incoming $welcomePrompt %s500 _bacd_options_menu.au
				fsm setstate GETDEST
			}
		} 
	} else {
		call close
	}
}

proc act_GotDestNoOption { } {
	global optionSelected
	global queueMessage
	global queueID
	global keepAliveTime
	global KATIMER
	global CLI
	global playMusicFlag 
	global callCloseFlag
	global svcUnavlbl
	global dropThroOption
	global dropThroMode
	global optionIndex
	global retryDigitCollect
	global retryMenuFlag

	set playMusicFlag 1
	set retryDigitCollect 0
	set KATIMER(keepTime) [clock seconds]
	if {$dropThroMode == 1} {
		set optionSelected [expr $optionIndex + $dropThroOption] 
	} else {
		# NULL for Operator
		set optionSelected NULL
	}
	set queueMessage(optionIDX) $optionSelected
	set queueMessage(callState) CALL_NEW
	set queueMessage(keepTime) $KATIMER(keepTime)
	set rval [sendmsg $queueID -p queueMessage]
	if { $rval == "unavailable" } {
		media play leg_incoming _bacd_disconnect.au
		set callCloseFlag 1
		set svcUnavlbl 1
	} else {
		if {$dropThroMode == 0} {
			set retryMenuFlag 0
			set liveMusicFeed 1
			media play leg_incoming moh:livemoh
			timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
		}
		timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
		fsm setstate NEWCALLMSG
	}
}

proc act_GotDest { } {
	global optionSelected
	global queueMessage
	global queueID
	global keepAliveTime
	global KATIMER
	global PARAM1
	global CLI
	global playMusicFlag 
	global callCloseFlag
	global svcUnavlbl
	global AATIMER
	global dialByExtension
	global retryMenuFlag
	global liveMusicFeed
	global optionIndex
	global retryDigitCollect
	global menuRetry

	set AATIMER(getDestTime) [clock seconds]
	set status [infotag get evt_status]
	set retryDigitCollect 0
	if {$status == "cd_005"} {
		set KATIMER(keepTime) [clock seconds]
		set optionSelected [infotag get evt_dcdigits]
		if {$optionSelected == $dialByExtension} {
			puts -nonewline "TCL AA: +++ Collect Extension Digits +++"
			set retryDigitCollect 1
			leg collectdigits leg_incoming PARAM1
			media play leg_incoming _bacd_enter_dest.au
			fsm setstate CALLTOEXTENSION
		} else {
			switch -exact $optionSelected {
				{#} {
					act_RetryMenu
				}
				{0} {
					act_GotDestNoOption
				}
				default {
					set playMusicFlag 1
					set retryMenuFlag 0
					set queueMessage(optionIDX) [expr $optionIndex + $optionSelected]
					set queueMessage(callState) CALL_NEW
					set queueMessage(keepTime) $KATIMER(keepTime)
					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
					##	media play leg_incoming _bacd_music_on_hold.au
						set liveMusicFeed 1
						media play leg_incoming moh:livemoh
						timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
						timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
						fsm setstate NEWCALLMSG
					}
				}
			}
		}
   	} elseif { ($status == "cd_001") || ($status == "cd_002") } {
		puts -nonewline "TCL AA: +++ No option selected +++"
		if { $CLI(menu-timeout) != "NONE" } {
			if { $menuRetry < $CLI(menu-timeout) } {
				set retryDigitCollect 1
				act_RetryMenu
				incr menuRetry
			} else {
				media play leg_incoming _bacd_xferto_operator.au
				fsm setstate OPTIONSELECTED
			}
		} else {
			set retryDigitCollect 1
			act_RetryMenu
		}
	} else {
		fsm setstate same_state
		set retryDigitCollect 1
		act_RetryMenu
	}
}

proc act_RetryMenu { } {
	global PARAM
	global invalidHuntGrp
	global invalidExtension
	global retryMenuFlag 
	global retryDigitCollect

	timer stop named_timer KEEP_ALIVE_TIMER
	timer stop named_timer SECOND_GREETING_TIMER
	set retryMenuFlag 1
	set retryDigitCollect 1
	leg collectdigits leg_incoming PARAM

	if {$invalidHuntGrp == 1} {
		media play leg_incoming _bacd_invalidoption.au %s500 _bacd_options_menu.au
		set invalidHuntGrp 0
	} elseif {$invalidExtension == 1} {
		media play leg_incoming _bacd_invalidoption.au %s500 _bacd_options_menu.au
		set invalidExtension 0
	} else {
		media play leg_incoming _bacd_options_menu.au
	}
	fsm setstate GETDEST
}

proc act_EvMediaDone { } {
	global callCloseFlag
	global playMusicFlag 
	global retryMenuFlag
	global liveMusicFeed
	global legDisconnectTimer
	global retryDigitCollect 

	if { $callCloseFlag == 1} {
		act_Cleanup
	} elseif { $playMusicFlag == 1} {
		set mediaStatus [infotag get evt_status]
		puts -nonewline "TCL AA: -- MEDIA STATUS = $mediaStatus --"
		if { $mediaStatus == "ms_001"} {
			puts -nonewline "TCL AA: -- ERROR: Unable to play prompt; File not found --"
			set liveMusicFeed 0
		}
		if {($retryMenuFlag == 0) && ($liveMusicFeed == 1)} {
			media play leg_incoming moh:livemoh
			puts -nonewline "TCL AA: +++ Playing MOH Livefeed +++"
		} elseif {($retryMenuFlag == 0) && ($liveMusicFeed == 0)} {
			media play leg_incoming _bacd_music_on_hold.au
			puts -nonewline "TCL AA: +++ Playing MOH +++"
		} else {
			if {$retryDigitCollect == 0} {
				puts -nonewline "TCL AA: -- Disconnect Leg Timer Started --"
				puts -nonewline "TCL AA: -- Leg will be disconnected in $legDisconnectTimer Seconds --"
				timer start leg_timer $legDisconnectTimer leg_incoming
				fsm setstate CALLDISCONNECT
			}
		}
	} else {
		if {$retryDigitCollect == 0} {
			puts -nonewline "TCL AA: -- Disconnect Leg Timer Started --"
			puts -nonewline "TCL AA: -- Leg will be disconnected in $legDisconnectTimer Seconds --"
			timer start leg_timer $legDisconnectTimer leg_incoming
			fsm setstate CALLDISCONNECT
		}
	}
}

proc act_HandleMessage { } {
	global optionSelected
	global callInfo
	global CLI
	global queueID
	global KATIMER
	global callCloseFlag
	global invalidHuntGrp
	global voiceMailDN
	global vmStatFlag
	global maxVMRetry
	global AATIMER
	global svcUnavlbl
	global vmSetupFlag
	global destHunt
	global dropThroMode
	global dropThroFlag
	global legDisconnectTimer
	global dropAgtFlag
	global retryMenuFlag
	global liveMusicFeed
	global isnName
	global isnInvokedFlag
	global isnTimeout
	global callAbandon

	set AATIMER(retTime) [clock seconds]
	set retryLimit [expr $AATIMER(retTime) - $AATIMER(curTime)]
	set msgFromService [infotag get evt_msg_source]
	infotag get evt_msg msgArray
	if { $retryLimit < $CLI(max-time-call-retry) } {
		if {([info exists msgArray(callState)] == 1) || ([info exists msgArray(optionIDX)] == 1)} {
			set KATIMER(keepTime) [clock seconds]
			switch -exact $msgArray(callState) {
				CALL_HUNT {
					set destHunt $msgArray(optionIDX)
					puts -nonewline "TCL AA: >>> Destination Huntgroup = $msgArray(optionIDX) <<<"
					if {$dropThroMode == 1} {
						set dropThroFlag 1
						set dropAgtFlag 1
						leg setup $destHunt callInfo leg_incoming
					} else {
						set dropThroFlag 0
						leg setup $destHunt callInfo -l leg_incoming
					}
					set vmSetupFlag 0
					set queueMessage(optionIDX) $optionSelected
					set queueMessage(callState) CALL_PROGRESS
					set queueMessage(keepTime) $KATIMER(keepTime)
					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
						fsm setstate PLACECALL
					}
				}
				CALL_RETRY {
					set dropThroFlag 0
					set destHunt $msgArray(optionIDX)
					leg setup $destHunt callInfo -l leg_incoming
					set vmSetupFlag 0
					set queueMessage(optionIDX) $optionSelected
					set queueMessage(callState) CALL_RETRY_PROGRESS
					set queueMessage(keepTime) $KATIMER(keepTime)
					set rval [sendmsg $queueID -p queueMessage]
					if { $rval == "unavailable" } {
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
						set svcUnavlbl 1
					} else {
						fsm setstate PLACECALL
					}
				}
				CALL_HOLD {
					set dropThroFlag 0
					if { $dropAgtFlag == 0} {
						set liveMusicFeed 1
						set retryMenuFlag 0
						media play leg_incoming _bacd_allagentsbusy.au
						timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
						set dropAgtFlag 1
					}
					timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
					fsm setstate CALLHOLD
				}
				NO_HUNT_GROUP {
					puts -nonewline "TCL AA: +++ Invalid option selected +++"
					set invalidHuntGrp 1
					act_RetryMenu
				}
				CALL_NAGT {
					if {$isnInvokedFlag == 1} {
						set AATIMER(nagtTime) [clock seconds]
						set handOffTime [expr $AATIMER(nagtTime) - $AATIMER(curTime)]
						if {$handOffTime > $isnTimeout} {
							set callAbandon 1
							puts -nonewline "TCL AA: >>> ISN Timeout, Handing off to ISN Application <<<"
							timer stop named_timer SECOND_GREETING_TIMER
							timer stop named_timer CALL_RETRY_TIMER
							if {$isnName == "NONE"} {
								puts -nonewline "TCL AA: -- ERROR: No ISN Application configured, Disconnecting the call --"
								act_Cleanup
							} else {
								handoff appl leg_incoming $isnName
								act_Cleanup
							}
						} else {
							timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
							fsm setstate CALLHOLD
						}
					} elseif {$maxVMRetry < $CLI(max-time-vm-retry)} {
						puts -nonewline "TCL AA: >>> No Agents are available; Forwarding to Voice Mail <<<"
						set callInfo(redirectNum) $msgArray(optionIDX)
						set dropThroFlag 0
						if { $dropAgtFlag == 0} {
							set liveMusicFeed 1
							set retryMenuFlag 0
							media play leg_incoming _bacd_allagentsbusy.au
							timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
							set dropAgtFlag 1
						}
						leg setup $voiceMailDN callInfo -l leg_incoming 
						set vmSetupFlag 1
						if {$vmStatFlag == 0} {
							set queueMessage(vmStat) $vmStatFlag
							set vmStatFlag 1
						}	
						set queueMessage(optionIDX) $optionSelected
						set queueMessage(callState) CALL_VM
						set queueMessage(keepTime) $KATIMER(keepTime)
						set rval [sendmsg $queueID -p queueMessage]
						if { $rval == "unavailable" } {
							media play leg_incoming _bacd_disconnect.au
							set callCloseFlag 1
							set svcUnavlbl 1
						} else {
							incr maxVMRetry
							puts -nonewline "TCL AA: >>> No of attempts to voice mail = $maxVMRetry <<<"
							fsm setstate PLACECALL
						}
					} else {
						puts -nonewline "TCL AA: >> Voice mail timeout, Disconnecting the call <<"
						timer stop named_timer SECOND_GREETING_TIMER
						timer stop named_timer CALL_RETRY_TIMER
						media play leg_incoming _bacd_disconnect.au
						set callCloseFlag 1
					}
				}
				CALL_REJECT {
					puts -nonewline "TCL AA: +++ Queue is Full; Call Rejected +++"
					timer stop named_timer SECOND_GREETING_TIMER
					timer stop named_timer CALL_RETRY_TIMER
					timer stop named_timer KEEP_ALIVE_TIMER
					set callCloseFlag 1
					playtone leg_incoming tn_busy
					timer start leg_timer $legDisconnectTimer leg_incoming
					fsm setstate CALLDISCONNECT
				}
				default {
					act_Cleanup
				}
			}
		} 
	} else {
		if {$isnInvokedFlag == 1} {
			set callAbandon 1
			puts -nonewline "TCL AA: >>> Maximum Retry Limit Reached, Handing off to ISN Application <<<"
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			if {$isnName == "NONE"} {
				puts -nonewline "TCL AA: -- ERROR: No ISN Application configured, Disconnecting the call --"
				act_Cleanup
			} else {
				handoff appl leg_incoming $isnName
				act_Cleanup
			}
		} elseif {$maxVMRetry < $CLI(max-time-vm-retry)} {
			puts -nonewline "TCL AA: >>> Maximum Retry Limit Reached, Forwarding to Voice Mail <<<"
			set dropThroFlag 0
			set callInfo(redirectNum) $destHunt
			leg setup $voiceMailDN callInfo -l leg_incoming
			set vmSetupFlag 1
			if {$vmStatFlag == 0} {
				set queueMessage(vmStat) $vmStatFlag
				set vmStatFlag 1
			}
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_VM
			set queueMessage(keepTime) $KATIMER(keepTime)
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				fsm setstate PLACECALL
				incr maxVMRetry
				puts -nonewline "TCL AA: >>> No of attempts to voice mail = $maxVMRetry <<<"
			}
		} else {
			puts -nonewline "TCL AA: >> Voice mail timeout, Disconnecting the call <<"
			media play leg_incoming _bacd_disconnect.au
			timer stop named_timer SECOND_GREETING_TIMER
			timer stop named_timer CALL_RETRY_TIMER
			set callCloseFlag 1
		}
	}
}
			
proc act_CallSetupDone { } {
	global busyPrompt
	global optionSelected
	global queueID
	global CLI
	global KATIMER
	global callCloseFlag
	global svcUnavlbl
	global dropThroFlag
	global liveMusicFeed
	global dropAgtFlag

	set status [infotag get evt_status]
	set KATIMER(keepTime) [clock seconds]
	puts "\n proc act_CallSetupDone"
	puts "\n IP IVR Leg Setup Status = $status"
	switch -exact $status {
		ls_000 {
			puts -nonewline "TCL AA: >> Call answered by the agent; Call Connected <<"
			if {$dropThroFlag == 1} {
				act_HandoffLegs
			} else {
				fsm setstate OUTGOINGLEGACTIVE
				media stop leg_incoming
				connection create leg_incoming leg_outgoing
			}
		} 
		ls_002 {
			puts -nonewline "TCL AA: >> Agent did not answer; Received Call NOAN <<"
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_NOAN
			set queueMessage(keepTime) $KATIMER(keepTime)
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
		ls_007 {
			puts -nonewline "TCL AA: >> Agent Busy <<"
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_BUSY
			set queueMessage(keepTime) $KATIMER(keepTime)
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
		default {
			puts -nonewline "TCL AA: +++ Received signal other than busy or noan +++"
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) CALL_TEMP_FAILURE
			set queueMessage(keepTime) $KATIMER(keepTime)
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				if {$dropThroFlag == 1} {
					set retryMenuFlag 0
					set liveMusicFeed 1
					set dropAgtFlag 1
					media play leg_incoming _bacd_allagentsbusy.au
					timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
				}
				timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
				fsm setstate CALLHOLD
			}
		}
	}
}

proc act_CallOnHold { } {
	global optionSelected
	global queueID
	global KATIMER
	global keepAliveTime
	global CLI
	global callCloseFlag
	global svcUnavlbl
	global retryMenuFlag
	global liveMusicFeed

	set retryTimer [infotag get evt_timer_name]
	set KATIMER(keepTime) [clock seconds]
	if {$retryTimer == "CALL_RETRY_TIMER"} {
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_RETRY
		set queueMessage(keepTime) $KATIMER(keepTime)
		set rval [sendmsg $queueID -p queueMessage]
		if { $rval == "unavailable" } {
			media play leg_incoming _bacd_disconnect.au
			set svcUnavlbl 1
			set callCloseFlag 1
		} else {
			timer start named_timer $CLI(call-retry-timer) CALL_RETRY_TIMER
		}
	} elseif {$retryTimer == "SECOND_GREEETING_TIMER"} {
		media play leg_incoming _bacd_allagentsbusy.au
		set retryMenuFlag 0
		set liveMusicFeed 1
		puts -nonewline "TCL AA: +++ Now playing second greeting prompt +++"
		timer start named_timer $CLI(second-greeting-time) SECOND_GREEETING_TIMER
	} elseif {$retryTimer == "KEEP_ALIVE_TIMER"} {
		if { $optionSelected != 0} {
			set queueMessage(optionIDX) $optionSelected
			set queueMessage(callState) HELLO
			set queueMessage(keepTime) $KATIMER(keepTime)
			set rval [sendmsg $queueID -p queueMessage]
			if { $rval == "unavailable" } {
				media play leg_incoming _bacd_disconnect.au
				set svcUnavlbl 1
				set callCloseFlag 1
			} else {
				timer start named_timer $keepAliveTime KEEP_ALIVE_TIMER
			}
		}
	}
}

proc act_HandoffToExtension { } {
	global maxExtensionLen
	global invalidExtension

	set status [infotag get evt_status]
	if {$status == "cd_004"} {
		set destExtension [infotag get evt_dcdigits]
		set destExtLen [string length $destExtension]
		set extLength [expr $maxExtensionLen - $destExtLen]
		if {($maxExtensionLen > 0) && ($extLength >= 0)} {
			handoff appl leg_incoming default "DESTINATION=$destExtension"
		} elseif {$maxExtensionLen == 0} {
			handoff appl leg_incoming default "DESTINATION=$destExtension"
		} elseif {($maxExtensionLen > 0) && ($extLength < 0)} {
			set invalidExtension 1
			fsm setstate same_state
			act_RetryMenu
		} else {
			set invalidExtension 1
			fsm setstate same_state
			act_RetryMenu
		}
   	} elseif { ($status == "cd_001") || ($status == "cd_002") } {
		puts -nonewline "TCL AA: +++ No Extension number entered +++"
		act_RetryMenu
	} else {
		set invalidExtension 1
		fsm setstate same_state
		act_RetryMenu
	}
}

proc act_HandoffLegs { } {
	global optionSelected
	global queueID
	global AATIMER	
	global KATIMER
	global callAbandon 
	global vmStatFlag
	global callCloseFlag
	global svcUnavlbl
	global vmSetupFlag
	global CLI
	global answerTime
	
	set AATIMER(ansTime) [clock seconds]
	if { $CLI(number-of-hunt-grps) == 1 } {
		set answerTime [expr $AATIMER(ansTime) - $AATIMER(curTime)]
	} else {
		set answerTime [expr $AATIMER(ansTime) - $AATIMER(getDestTime)]
	}
	if { $answerTime > $CLI(max-time-call-retry)} {
		puts -nonewline "TCL AA: -- Answer Time is $answerTime --"
	}
	set callAbandon 0
	if {($vmStatFlag == 1) && ($vmSetupFlag == 1)} {
		set queueMessage(vmStat) $vmStatFlag
	}	
	set queueMessage(optionIDX) $optionSelected
	set queueMessage(callState) CALL_HANDOFF
	set queueMessage(ansTime) $answerTime
	set queueMessage(keepTime) $AATIMER(ansTime)
	set rval [sendmsg $queueID -p queueMessage]
	if { $rval == "unavailable" } {
		media play leg_incoming _bacd_disconnect.au
		set svcUnavlbl 1
		set callCloseFlag 1
	} else {
		set legIN [infotag get leg_incoming]
		set legOUT [infotag get leg_outgoing]
		puts -nonewline "TCL AA: >>> Incoming LEG ID = $legIN; Outgoing LEG ID = $legOUT <<<"
		handoff appl leg_all default
		act_Cleanup
	}
}

proc act_Cleanup { } {
	global optionSelected
	global queueID
	global callAbandon
	global AATIMER
	global KATIMER
	global svcUnavlbl
	global CLI

	if { ($optionSelected != 0) && ($callAbandon == 1) && ($svcUnavlbl == 0) } {
		set AATIMER(abandonTime) [clock seconds]
		if {$CLI(number-of-hunt-grps) == 1} {
			set abandonTime [expr $AATIMER(abandonTime) - $AATIMER(curTime)]
		} else {
			set abandonTime [expr $AATIMER(abandonTime) - $AATIMER(getDestTime)]
		}
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_HANGUP
		set queueMessage(abandonTime) $abandonTime
		set queueMessage(keepTime) $AATIMER(abandonTime)
		set rval [sendmsg $queueID -p queueMessage]
	} elseif {($optionSelected != 0) && ($callAbandon == 0) && ($svcUnavlbl == 0)} {
		set KATIMER(keepTime) [clock seconds]
		set queueMessage(optionIDX) $optionSelected
		set queueMessage(callState) CALL_HANGUP
		set queueMessage(keepTime) $KATIMER(keepTime)
		set rval [sendmsg $queueID -p queueMessage]
	}
	call close
}

requiredversion 2.0
init 

init_ConfigVars
#----------------------------------
#   State Machine
#----------------------------------
	set fsm(any_state,ev_disconnected)   "act_Cleanup  same_state"
	set fsm(CALL_INIT,ev_setup_indication) "act_Setup  GETDEST"
	set fsm(CALL_INIT,ev_setup_indication) "act_Setup  OPTIONSELECTED"
	set fsm(CALL_INIT,ev_handoff) "act_Handoff_Activity  GETDEST"
	set fsm(CALL_INIT,ev_handoff) "act_Handoff_Activity  OPTIONSELECTED"
	set fsm(OPTIONSELECTED,ev_media_done) "act_GotDestNoOption NEWCALLMSG"
	set fsm(GETDEST,ev_collectdigits_done) "act_GotDest NEWCALLMSG"
	set fsm(CALLTOEXTENSION,ev_collectdigits_done) "act_HandoffToExtension same_state"
	set fsm(NEWCALLMSG,ev_msg_indication) "act_HandleMessage PLACECALL"
	set fsm(NEWCALLMSG,ev_msg_indication) "act_HandleMessage CALLHOLD"
	set fsm(CALLHOLD,ev_named_timer) "act_CallOnHold NEWCALLMSG"
	set fsm(any_state,ev_media_done) "act_EvMediaDone same_state"
	set fsm(any_state,ev_named_timer) "act_CallOnHold same_state"
	set fsm(PLACECALL,ev_setup_done)   "act_CallSetupDone  OUTGOINGLEGACTIVE"
	set fsm(OUTGOINGLEGACTIVE,ev_create_done) "act_HandoffLegs HANDOFF"
	set fsm(CALLDISCONNECT,ev_disconnect_done) "act_Cleanup  same_state"
	set fsm(CALLDISCONNECT,ev_leg_timer) "act_Cleanup  same_state"
  
	fsm define fsm CALL_INIT
