# Script Locked by: CiscoOfficial
# Script Version: 2.0.0.0
# Script Name: app-cme-did
# Script Lock Date: Wed Jul 05 14:07:50 2005
# January 26, 2005, Satish Ananthanarayana
#		 
# Copyright (c) 2006 by cisco Systems, Inc.
# All rights reserved.
#------------------------------------------------------------------
#		 


proc init { } {
	global PARAM1
	global callInfo
	global legConnected

	set PARAM1(interruptPrompt) true
	set PARAM1(abortKey) *
	set PARAM1(terminationKey) #

	set legConnected false
}

proc init_ConfigVars { } {
	global cfgFail
	global priPrefix
	global didPrefix
	global didMin
	global didMax
	global didMaxMap
	global didMinMap

	set cfgFail 0

	if [infotag get cfg_avpair_exists secondary-prefix] {
		set priPrefix [string trim [infotag get cfg_avpair secondary-prefix]]
		if { ($priPrefix >= 0) && ($priPrefix <= 99) } {
			puts -nonewline ">>> TCL DID: secondary-prefix $priPrefix is Valid <<<"
		} else {
			puts -nonewline ">>> TCL DID: ERROR: secondary-prefix $priPrefix is Invalid <<<"
			puts -nonewline "TCL DID: secondary-prefix valid values are 0 - 99 --"
			set cfgFail 1
			call close
		}
	} else {
		set priPrefix "NONE"
	}
	if [infotag get cfg_avpair_exists did-prefix] {
		set didPrefix [string trim [infotag get cfg_avpair did-prefix]]
		if { ($didPrefix >= 0) && ($didPrefix <= 99) } {
			puts -nonewline ">>> TCL DID: did-prefix $didPrefix is Valid <<<"
		} else {
			puts -nonewline ">>> TCL DID: ERROR: did-prefix $didPrefix is Invalid <<<"
			puts -nonewline "TCL DID: -- did-prefix valid values are 0 - 99 --"
			set cfgFail 1
			call close
		}
	} else {
		set didPrefix "NONE"
		puts -nonewline "TCL DID: -- ERROR: Mandatory parameter did-prefix does not exist --"
		puts -nonewline "TCL DID: -- ERROR: Valid values are 0 - 99 --"
		set cfgFail 1
		call close
	}
	if [infotag get cfg_avpair_exists co-did-min] {
		set didMin [string trim [infotag get cfg_avpair co-did-min]]
		if {$didMin < 0} {
			puts -nonewline "TCL DID: -- ERROR: co-did-min $didMin is Invalid --"	
			set cfgFail 1
			call close
		}
	} else {
		set didMin 0
		puts -nonewline "TCL DID: -- ERROR: Mandatory parameter co-did-min does not exist --"
		set cfgFail 1
		call close
	}
	if [infotag get cfg_avpair_exists store-did-max] {
		set didMaxMap [string trim [infotag get cfg_avpair store-did-max]]
		if {$didMaxMap < 0} {
			puts -nonewline "TCL DID: -- ERROR: store-did-max $didMaxMap is Invalid --"	
			set cfgFail 1
			call close
		}
	} else {
		set didMaxMap 0
		puts -nonewline "TCL DID: -- ERROR: Mandatory parameter store-did-max does not exist --"
		set cfgFail 1
		call close
	}
	if [infotag get cfg_avpair_exists store-did-min] {
		set didMinMap [string trim [infotag get cfg_avpair store-did-min]]
		if {$didMinMap < 0} {
			puts -nonewline "TCL DID: -- ERROR: store-did-min $didMinMap is Invalid --"	
			set cfgFail 1
			call close
		}
	} else {
		set didMinMap 0
		puts -nonewline "TCL DID: -- ERROR: Mandatory parameter store-did-min does not exist --"
		set cfgFail 1
		call close
	}
	if [infotag get cfg_avpair_exists co-did-max] {
		set didMax [string trim [infotag get cfg_avpair co-did-max]]
		if {$didMax < 0} {
			puts -nonewline "TCL DID: -- ERROR: co-did-max $didMax is Invalid --"	
			set cfgFail 1
			call close
		}
	} else {
		set didMax 0
		puts -nonewline "TCL DID: -- ERROR: Mandatory parameter co-did-max does not exist --"
		set cfgFail 1
		call close
	}
}

proc init_perCallVars { } {
	global ani
	global dnis
	global callInfo
	global primaryFail
	global dnisLen
	global dnisNew
	global dnisPrim

	set ani [infotag get leg_ani]

	set callInfo(originationNum) $ani
	set primaryFail 0
	set dnis 0
	set dnisLen 0
	set dnisNew 0
	set dnisPrim 0
}

proc act_Setup { } {
	global PARAM1
	global callInfo
	global dnis
	global legConnected
	global cfgFail
	global priPrefix
	global didPrefix
	global didMin
	global didMax
	global didMaxMap
	global didMinMap
	global primaryFail
	global dnisLen
	global dnisNew
	global dnisPrim

	set tempMap [expr $didMaxMap - $didMinMap]
	set tempDid [expr $didMax - $didMin]
	set didList ""
	set didListSec ""
	set tempcat ""

	if { $cfgFail == 0 } {
		init_perCallVars
		infotag set med_language 1
		if {[infotag get leg_isdid]} {
			set dnis [infotag get leg_dnis]
			puts -nonewline "TCL DID: >>> DNIS = $dnis <<<"
			set dnisTempLen [expr [string length $dnis] - [string length $didMin]]
			set dnis [string range $dnis $dnisTempLen end]
			puts -nonewline "TCL DID: >>> MODIFIED DNIS = $dnis <<<"
			set dnisLen [string length $dnis]
			if { $dnis == "" } {
				leg setupack leg_incoming
				leg proceeding leg_incoming
				leg connect leg_incoming
				set legConnected true 
				puts -nonewline "TCL DID: -- ERROR: NO DID Present --"
				media play leg_incoming _disconnect.au
				fsm setstate CALLDISCONNECT
			} elseif { ($tempDid > $tempMap) || ($didMin > $didMax) || ($didMinMap > $didMaxMap) } {
				leg setupack leg_incoming
				leg proceeding leg_incoming
				leg connect leg_incoming
				set legConnected true 
				puts -nonewline "TCL DID: -- ERROR: did-max and did-min out of range --"
				media play leg_incoming _disconnect.au
				fsm setstate CALLDISCONNECT
			} elseif { ($dnis >= $didMin) && ($dnis <= $didMax) } {
				if { ($didMin > $didMinMap) && ($didMax > $didMaxMap) } {
					set dnisNew [expr $dnis - ($didMin - $didMinMap)]
					set dnisNewLen [string length $dnisNew]
					if {$dnisNewLen < $dnisLen} {
						for {set var 0} {$var < [expr $dnisLen - $dnisNewLen]} {incr var} {
							set tempcat 0
							set dnisNew [join [lappend tempcat $dnisNew] {}]
						}
					}
					set dnisNew [join [lappend didList $didPrefix $dnisNew] {}]
					if { $priPrefix != "NONE" } {
						set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
						set primaryFail 1
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
						fsm setstate HANDOFF
					} else {
						set primaryFail 0
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisNew"
						fsm setstate HANDOFF
					}
				} elseif { ($didMinMap > $didMin) && ($didMaxMap > $didMax) } {
					set dnisNew [expr $dnis + ($didMinMap - $$didMin)]
					set dnisNewLen [string length $dnisNew]
					if {$dnisNewLen < $dnisLen} {
						for {set var 0} {$var < [expr $dnisLen - $dnisNewLen]} {incr var} {
							set tempcat 0
							set dnisNew [join [lappend tempcat $dnisNew] {}]
						}
					}
					set dnisNew [join [lappend didList $didPrefix $dnisNew] {}]
					if { $priPrefix != "NONE" } {
						set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
						set primaryFail 1
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
						fsm setstate HANDOFF
					} else {
						set primaryFail 0
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisNew"
						fsm setstate HANDOFF
					}
				} elseif { ($didMin == $didMinMap) && ($didMax == $didMaxMap)} {
					set dnisNew [join [lappend didList $didPrefix $dnis] {}]
					if { $priPrefix != "NONE" } {
						set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
						set primaryFail 1
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
						fsm setstate HANDOFF
					} else {
						set primaryFail 0
						leg setupack leg_incoming
						handoff callappl leg_incoming default "DESTINATION=$dnisNew"
						fsm setstate HANDOFF
					}
				} else {
					leg setupack leg_incoming
					leg proceeding leg_incoming
					leg connect leg_incoming
					set legConnected true 
					media play leg_incoming _disconnect.au
					fsm setstate CALLDISCONNECT
				}
			} else {
				leg setupack leg_incoming
				leg proceeding leg_incoming
				leg connect leg_incoming
				set legConnected true 
				puts -nonewline "TCL DID: -- ERROR: DNIS out of range --"
				media play leg_incoming _disconnect.au
				fsm setstate CALLDISCONNECT
			}
		} else {
			leg setupack leg_incoming
			playtone leg_incoming tn_dial

			set PARAM1(dialPlan) false
			set PARAM1(maxDigits) [string length $didMin]
			leg collectdigits leg_incoming PARAM1
		}
	} else {
		call close
	}
}

proc act_GotDest { } {
	global dnis
	global callInfo
	global legConnected
	global priPrefix
	global didPrefix
	global didMin
	global didMax
	global didMaxMap
	global didMinMap
	global primaryFail
	global dnisLen
	global dnisNew
	global dnisPrim

	set didList ""
	set didListSec ""
	set tempcat ""
    
	set status [infotag get evt_status]
	puts -nonewline "TCL DID: >>> DIGIT COLLECT STATUS = $status <<<"
	set tempMap [expr $didMaxMap - $didMinMap]
	set tempDid [expr $didMax - $didMin]
    
	if {  ($status == "cd_004") || ($status == "cd_006") || ($status == "cd_005")} {
		set dnis [infotag get evt_dcdigits]
		puts -nonewline "TCL DID: >>> DNIS = $dnis <<<"
		set dnisTempLen [expr [string length $dnis] - [string length $didMin]]
		set dnis [string range $dnis $dnisTempLen end]
		puts -nonewline "TCL DID: >>> MODIFIED DNIS = $dnis <<<"
		set dnisLen [string length $dnis]
		if { $dnis == "" } {
			leg proceeding leg_incoming
			leg connect leg_incoming
			set legConnected true 
			puts -nonewline "TCL DID: -- ERROR: NO DID Present --"
			media play leg_incoming _disconnect.au
			fsm setstate CALLDISCONNECT
		} elseif { ($tempDid > $tempMap) || ($didMin > $didMax) || ($didMinMap > $didMaxMap) } {
			leg proceeding leg_incoming
			leg connect leg_incoming
			set legConnected true 
			puts -nonewline "TCL DID: -- ERROR: did-max and did-min configured out of range --"
			media play leg_incoming _disconnect.au
			fsm setstate CALLDISCONNECT
		} elseif { ($dnis >= $didMin) && ($dnis <= $didMax) } {
			if { ($didMin > $didMinMap) && ($didMax > $didMaxMap) } {
				set dnisNew [expr $dnis - ($didMin - $didMinMap)]
				set dnisNewLen [string length $dnisNew]
				if {$dnisNewLen < $dnisLen} {
					for {set var 0} {$var < [expr $dnisLen - $dnisNewLen]} {incr var} {
						set tempcat 0
						set dnisNew [join [lappend tempcat $dnisNew] {}]
					}
				}
				set dnisNew [join [lappend didList $didPrefix $dnisNew] {}]
				puts -nonewline "TCL DID: >> Prefixed DID = $dnisNew <<"
				if { $priPrefix != "NONE" } {
					set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
					puts -nonewline "TCL DID: >> Secondary Prefixed DID = $dnisPrim <<"
					set primaryFail 1
					leg proceeding leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
					fsm setstate HANDOFF
				} else {
					set primaryFail 0
					leg proceeding leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisNew"
					fsm setstate HANDOFF
				}
			} elseif { ($didMinMap > $didMin) && ($didMaxMap > $didMax) } {
				set dnisNew [expr $dnis + ($didMinMap - $$didMin)]
				set dnisNewLen [string length $dnisNew]
				if {$dnisNewLen < $dnisLen} {
					for {set var 0} {$var < [expr $dnisLen - $dnisNewLen]} {incr var} {
						set tempcat 0
						set dnisNew [join [lappend tempcat $dnisNew] {}]
					}
				}
				set dnisNew [join [lappend didList $didPrefix $dnisNew] {}]
				if { $priPrefix != "NONE" } {
					set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
					set primaryFail 1
					leg setupack leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
					fsm setstate HANDOFF
				} else {
					set primaryFail 0
					leg setupack leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisNew"
					fsm setstate HANDOFF
				}
			} elseif { ($didMin == $didMinMap) && ($didMax == $didMaxMap)} {
				set dnisNew [join [lappend didList $didPrefix $dnis] {}]
				puts -nonewline "TCL DID: >> Prefixed DID = $dnisNew <<"
				if { $priPrefix != "NONE" } {
					set dnisPrim [join [lappend didListSec $priPrefix $dnisNew] {}]
					puts -nonewline "TCL DID: >> Secondary Prefixed DID = $dnisPrim <<"
					set primaryFail 1
					leg proceeding leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisPrim"
					fsm setstate HANDOFF
				} else {
					set primaryFail 0
					leg proceeding leg_incoming
					handoff callappl leg_incoming default "DESTINATION=$dnisNew"
					fsm setstate HANDOFF
				}
			} else {
				leg setupack leg_incoming
				leg proceeding leg_incoming
				leg connect leg_incoming
				set legConnected true 
				puts -nonewline "TCL DID: -- ERROR: DNIS out of range --"
				media play leg_incoming _disconnect.au
				fsm setstate CALLDISCONNECT
			}
		} else {
			leg proceeding leg_incoming
			leg connect leg_incoming
			set legConnected true 
			puts -nonewline "TCL DID: -- ERROR: DNIS out of range --"
			media play leg_incoming _disconnect.au
			fsm setstate CALLDISCONNECT
		}
	} else {
		puts "\nCall [infotag get con_all] got event $status collecting destination"
		# use invalid-number cause code
		leg disconnect leg_incoming -c28
		call close
	}
}

proc act_CallSetupDone { } {
	global busyPrompt
	global legConnected 
	global primaryFail
	global dnisNew

	set status [infotag get evt_handoff_string]
	if { [string length $status] != 0} {
		regexp {([0-9][0-9][0-9])} $status StatusCode
		puts "IP IVR Disconnect Status = $status" 
		switch $StatusCode {
			"016" {
				puts "\n Connection success"
				fsm setstate CONTINUE
				act_Cleanup 
			}
			default {
				if { ($StatusCode == "017") } {
					if {$primaryFail != 1} {
						if { $legConnected == "false" } {
							leg proceeding leg_incoming  
							leg connect leg_incoming  
							set legConnected true 
						}
						playtone leg_incoming tn_busy
						timer start leg_timer 10 leg_incoming
						fsm setstate CALLDISCONNECT
					} else {
						set primaryFail 0
						handoff callappl leg_incoming default "DESTINATION=$dnisNew"
						fsm setstate HANDOFF
					}
				} else {
					if {$primaryFail != 1} {
						if { $legConnected == "false" } {
							leg proceeding leg_incoming  
							leg connect leg_incoming  
							set legConnected true 
						}
						media play leg_incoming _disconnect.au
						fsm setstate CALLDISCONNECT
					} else {
						set primaryFail 0
						handoff callappl leg_incoming default "DESTINATION=$dnisNew"
						fsm setstate HANDOFF
					}
				}
			}
		} 
	} else {
		puts "\n Caller disconnected" 
		fsm setstate CALLDISCONNECT 
		act_Cleanup 
	}
}

proc act_Cleanup { } {
	call close
}

requiredversion 2.0
init 

init_ConfigVars
#----------------------------------
#   State Machine
#----------------------------------
  set fsm(any_state,ev_disconnected)   "act_Cleanup	same_state"
  
  set fsm(CALL_INIT,ev_setup_indication) "act_Setup	GETDEST"

#  set fsm(CALL_INIT,ev_setup_indication) "act_Setup	HANDOFF"

  set fsm(GETDEST,ev_collectdigits_done)  "act_GotDest	HANDOFF"

  set fsm(HANDOFF,ev_returned)   "act_CallSetupDone	CONTINUE"
 
  set fsm(CALLDISCONNECT,ev_media_done) "act_Cleanup	same_state"

  set fsm(CALLDISCONNECT,ev_disconnect_done) "act_Cleanup	same_state"

  set fsm(CALLDISCONNECT,ev_leg_timer) "act_Cleanup	same_state"
  
  fsm define fsm CALL_INIT
