//
//  SecondViewController.m
//
//  Copyright (c) 2013 Cisco Systems, Inc. All Rights Reserved.
//

#import "SecondViewController.h"

#import "ThirdViewController.h"

#import <JabberGuest/JabberGuest.h>

@interface SecondViewController () <CJGuestCallViewControllerDelegate> {
    CJGuestCallViewController * jabberG;
}
@end

@implementation SecondViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        [[self navigationItem] setTitle:@"Second"];
        
        UIBarButtonItem * bbi = [[UIBarButtonItem alloc] initWithBarButtonSystemItem:UIBarButtonSystemItemPlay
                                                                              target:self
                                                                              action:@selector(nextStep:)];
        
        [[self navigationItem] setRightBarButtonItem:bbi];
    }
    return self;
}

- (IBAction)nextStep:(id)sender
{
    ThirdViewController *tvc = [[ThirdViewController alloc] init];
    
    UIBarButtonItem * backButton = [[UIBarButtonItem alloc] initWithTitle:@"Second"
                                                                    style:UIBarButtonItemStyleBordered
                                                                   target:nil
                                                                   action:nil];
    [self.navigationItem setBackBarButtonItem:backButton];
    
    [[self navigationController] pushViewController:tvc
                                           animated:YES];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (void)callFinishedForCallController:(CJGuestCallViewController *)callController
{
    [self.navigationController popViewControllerAnimated:YES];
}

- (void)moreButtonPressedForCallController:(CJGuestCallViewController *)callController
{
    UIAlertView * moreAlert = [[UIAlertView alloc] initWithTitle:@"More"
                                                         message:@"The more button was pressed."
                                                        delegate:nil
                                               cancelButtonTitle:@"Ok"
                                               otherButtonTitles:nil];
    [moreAlert show];
}

- (IBAction)contactCustomerSupportUsingNavController:(id)sender {
    
    jabberG = [[CJGuestCallViewController alloc] init];
    
    if (jabberG) {
        
        [jabberG setServerName:@"jabberguestsandbox.cisco.com"];
        [jabberG setToURI:@"5555"];
        
        jabberG.delegate = self;
        
        UIBarButtonItem * backButton = [[UIBarButtonItem alloc] initWithTitle:@"Back"
                                                                           style:UIBarButtonItemStyleBordered
                                                                          target:nil
                                                                          action:nil];
        [self.navigationItem setBackBarButtonItem:backButton];
        
        [self.navigationController pushViewController:jabberG animated:YES];
    }
}

@end
