/*
 File: AppViewController.m
 Abstract: Application's view controller.
 
 Copyright (c) 2013 Cisco Systems, Inc. All Rights Reserved.
 
 */

#import "AppViewController.h"

#import "LiveSupportView.h"

@interface AppViewController () <LiveSupportViewDelegate> {
    LiveSupportView * lsv;
}

@property (weak, nonatomic) IBOutlet UIButton *callButton;

@end

@implementation AppViewController

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.callButton.titleLabel.textAlignment = NSTextAlignmentCenter;
}

- (IBAction)callLiveSupport:(id)sender
{
    lsv = [[LiveSupportView alloc] initWithFrame:CGRectMake(self.view.frame.size.width - 300,
                                                            0.0,
                                                            300,
                                                            300)];
    lsv.delegate = self;
    [self.view addSubview:lsv];
}

# pragma mark - Live Support Controller Delegate

- (void)supportCallIsFinished
{
    [lsv removeFromSuperview];
}

@end
