/*
  File: JCRViewController.m
  Abstract: The controller class that puts together the JabberC URL request and tries to open it.
  Version 1.0

  Copyright (c) 2013 Cisco Systems, Inc. All Rights Reserved.

*/

#import "JCRViewController.h"

@interface JCRViewController ()

@end

@implementation JCRViewController

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)launchJabberGuest:(id)sender {
    NSString * serverName = self.serverName.text;
    NSString * encodedURI = [self.uri.text stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
    NSURL * url = [NSURL URLWithString:[@"jabberc://" stringByAppendingFormat:@"%@?uri=%@", serverName, encodedURI]];
    
    UIApplication * thisApp = [UIApplication sharedApplication];
    if ([thisApp canOpenURL:url])
    {
        [thisApp openURL:url];
    }
    else
    {
        UIAlertView * alertView = [[UIAlertView alloc] initWithTitle:@"No Jabber Guest App Found"
                                                             message:@"The Jabber Guest App is not installed."
                                                            delegate:nil
                                                   cancelButtonTitle:@"OK"
                                                   otherButtonTitles:nil];
        [alertView show];
    }
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    
    [self.view endEditing:YES];
}

@end
