#!/bin/bash

CURRENT_SCRIPTPATH=$(dirname "${0}")

source "${CURRENT_SCRIPTPATH}"/common_utils.sh
source "${CURRENT_SCRIPTPATH}"/upgrade_utils.sh

# Version path to follow to upgrade the corresponding env file.
# Note: This must be always sorted values and corresponding upgrade funtions must be present on this file.
# Eg: If the value contains "0, 2.5, 3.2" the following functions must be present
# upgrade_0_to_2dot5(), upgrade_2dot5_to_3dot2()
VERSION_PATH="0, 2.0"

# Function to upgrade 15.0 config
function upgrade_0_to_2dot0() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.0"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"

}