#!/bin/bash
##
# Copyright (c) Cisco Systems, Inc.
# All rights reserved.
#
# This script start|stop|reload|clear_cache reverse proxy in a podman container with configurations
# generated as per provided environment data
##
SCRIPTPATH=$(dirname ${0})
source "${SCRIPTPATH}/launcher_utilities.sh"

function usage() {
	echo "USAGE: ${0} [options...] (start|stop|reload|clear_cache|hot_reload)"
	echo "Options: -e <ENV-DIR> -i <INSTALLER-ENV-FILE1> -i <INSTALLER-ENV-FILE2> ... "
	echo "INSTALLER-ENV-FILE: Mandatory : Installer env files ... Multiple files can be provided to override base env"
	echo "ENV-DIR: Mandatory for start, Optional for other actions : Reverseproxy environment config data directory"
	echo "Example usage: ${0} -e /path/to/env/dir -i /installer/env/1 -i /installer/env/override/1 -i /installer/env/override/2 start"
	echo "Example usage: ${0} -e /path/to/env/dir -i /installer/env/1 -r my_container_name hot_reload"
	echo "Example usage: ${0} -e /path/to/env/dir -i /installer/env/1 -r my_container_name -y hot_reload"
	exit 1
}

main "$@"|| { 
	echo "[ERROR] Failed to ${@: -1} reverse proxy.";
	podman && podman system prune -f;
	exit 1; 
}
