#!/bin/bash
##
# Copyright (c) Cisco Systems, Inc.
# All rights reserved.
#
# This script start/stop/restart reverse proxy in a podman container for
# dev local ennvironment i.e running locally from mac
# Default proxy environment data is present in directory ${SCRIPTPATH}/dev_local_envs
##

SCRIPTPATH=$(dirname ${0})
source "${SCRIPTPATH}/launcher_utilities.sh"
DEPLOYMENT_ENV_DIR="${SCRIPTPATH}/dev_local_envs"
BASE_INSTALLER_ENV="${SCRIPTPATH}/installer.env"
INSTALLER_ENV_OVERRIDE="${SCRIPTPATH}/installer.dev.env"
REVERSE_PROXY_OPENRESTY_CONFIGS_DIR="${SCRIPTPATH}/../reverse-proxy-openresty-configs"
REVERSE_PROXY_OPENRESTY_CONTAINER_DIR="${SCRIPTPATH}/../reverse-proxy-openresty-container"

function usage() {
	echo "USAGE: ${0} (start|stop|reload|clear_cache)"
	echo "All params are mandatory"
	exit 1
}

function prestart_hook() {
	${REVERSE_PROXY_OPENRESTY_CONTAINER_DIR}/build_podman_image.sh
	rc=$?
    if [ ! $rc -eq 0 ]; then
        exit $rc
    fi
}

function override_podman_run_args() {
	# Method to override/modify default podman run args
	PODMAN_RUN_ARGS="${PODMAN_RUN_ARGS} --hostname "${CONTAINER_HOSTNAME}" --domainname "${CONTAINER_DOMAIN}" \
    --publish "${NGX_PRXY_FIN_PORT}:${NGX_PRXY_FIN_PORT}" \
    --publish "${NGX_PRXY_CUIC_PORT}:${NGX_PRXY_CUIC_PORT}" \
    --publish "${NGX_PRXY_CUIC_DOC_PORT}:${NGX_PRXY_CUIC_DOC_PORT}" \
    --publish "${NGX_PRXY_LD_PORT}:${NGX_PRXY_LD_PORT}" \
    --publish "${NGX_PRXY_LD_SCKT_IO_PORT}:${NGX_PRXY_LD_SCKT_IO_PORT}" \
    --publish "${NGX_PRXY_IDS_PORT}:${NGX_PRXY_IDS_PORT}" \
    --publish "${NGX_PRXY_CHAT_PORT}:${NGX_PRXY_CHAT_PORT}" \
    --publish "${NGX_PRXY_STATIC_FILES_PORT}:${NGX_PRXY_STATIC_FILES_PORT}" \
    -v "${HOSTS_FILE}:${CONTAINER_HOSTS_FILE}" "
}

[ "$#" -eq 1 ] && { main -e ${DEPLOYMENT_ENV_DIR} -i ${BASE_INSTALLER_ENV} -i ${INSTALLER_ENV_OVERRIDE} "${1}"; } || usage
