--[[
    This module helps in blocking websocket connections made from clients, 
    unless there are successfully authenticated users connected through the IP address of the client.
    Helps in preventing DOS/DDOS attacks by initiating connections to websocket.
    Since only payload for the initial XMPP request segment has authentication for users,
    and since javascript websocket API doesn't inherently support custom headers,
    it is difficult to prevent users from initiating a connection.
    The assumption here is that, any user does an authenticated REST call,
    before initiating a websocket connection.
    Also, the IP address of the agent that uses REST endpoints, 
    is the same as IP address of from which the websocket connection is made.
--]]


-- The shared dictionary that stores the IP addresses of successfully authenticated users.
local ipstore = ngx.shared.ipstore
-- Fetching the client IP address to check if it is authorized to make a websocket connection.
local clientip = ngx.var.remote_addr

if ipstore:get(clientip) == nil then
    ngx.log(ngx.ERR, "The ip [", clientip, "] is unauthorized to create a websocket connections")
    return ngx.exit(ngx.HTTP_UNAUTHORIZED)
end
