-- This module helps in retreiving all the valid urls possible under desktop webapp
-- Checks if the url received under desktop webapp is a valid one.If invalid, returns 401, else forwards the request.

-- include required libraries 
local _utils = require("utils")
local _authHeader = require("auth_header")
local UnauthenticatedDesktopResourcesManager = require("unauthenticated_desktopresources_manager")
local desktopurlcount = ngx.shared.desktopurlcount


-- http_authorization has the authorization header
local authorization = ngx.var.http_authorization

-- server_name to which is serving the request
local serverName = ngx.var.server_name
if serverName == nil then
   serverName = ngx.var.server_addr
end

local resource = ngx.var.uri
if string.sub(resource, -1) == "/" then 
	resource = resource:sub(1,-2)
end
 
local desktopResourcesUrl = "https://" .. serverName .. ":" .. ngx.var.server_port .. "/desktop/api/ResourceURLs?type=desktop"
UnauthenticatedDesktopResourcesManager.getDesktopResources(serverName, desktopResourcesUrl)
 

if desktopurlcount:get("size") == nil or desktopurlcount:get("size") == 0 then
   return
end


local desktopurllist = ngx.shared.desktopurllist
local resourceExists = desktopurllist:get(resource)

--[[
   Check if resource exists in the resources list.
   If present, return which continue with intended desktop api
   If not present, return with 404 NOT FOUND
]]
if resourceExists then
   return
else
   -- Block the user from accessing the desktop API's
   return ngx.exit(ngx.HTTP_NOT_FOUND)
end 
