-- This module helps in retreiving all the valid urls possible under 3rdparty webapp
-- Checks if the url received under 3rdpartygaget webapp is a valid one.If invalid, returns 401, else forwards the request.

-- include required libraries 
local _utils = require("utils")
local _authHeader = require("auth_header")
local UnauthenticatedResourcesManager = require("unauthenticated_thirdpartyresources_manager")



-- http_authorization has the authorization header
local authorization = ngx.var.http_authorization

-- server_name to which is serving the request
local serverName = ngx.var.server_name
if serverName == nil then
   serverName = ngx.var.server_addr
end

-- backend upstream url which to be used for retrieving list of allowed 3rdparty gadgets  
local thirdpartyGadgetsUrl = "https://" .. serverName .. ":" .. ngx.var.server_port .. "/desktop/api/ResourceURLs?type=3rdParty"
UnauthenticatedResourcesManager.getThirdPartyGadgetResources(serverName, thirdpartyGadgetsUrl)
local thirdpartygadgeturlcount = ngx.shared.thirdpartygadgeturlcount
local resource = ngx.var.uri
if thirdpartygadgeturlcount:get("size") == nil or thirdpartygadgeturlcount:get("size") == 0 then
   -- When there are error and not populated the cache, we should return 404 always.
   ngx.log(ngx.NOTICE, "thirdpartygadgeturlcount is empty. [", ngx.worker.id(), "]")
   return ngx.exit(ngx.HTTP_NOT_FOUND)
end

local thirdpartygadgeturllist = ngx.shared.thirdpartygadgeturllist
local resourceExists = thirdpartygadgeturllist:get(resource)

--[[
   Check if resource exists in the resources list.
   If present, return which continue with intended 3rdpartygadget api
   If not present, return with 404 NOT FOUND
]]
if resourceExists then
   return
else
   -- Block the user from accessing the 3rdparty gadget API's
   ngx.log(ngx.NOTICE, "Requested URL is not present in allowed list of 3rdParty URLs. If it is newly added file, please wait for upto 8 minutes to get caches refreshed. [", ngx.worker.id(), "]")
   return ngx.exit(ngx.HTTP_NOT_FOUND)
end 
