-- This module helps in blocking un-authorized user from accessing finesse API's
-- 1. Checks the header custom-auth-header, if present takes the authorization from this header, else takes the header from authorization header.
-- 2. Starts the Thread for fetching the users in the system.
-- 3. checks if user is present in the list of users fetched, if not present returns 401.
-- 4. If user is present, proceeds with the request and stores the passwords hash and ensures the further requests dont do auth for next 15min if the
--    password provided is correct(checks the hash with the one stored for the user).
-- NOTE: Applicable only for NON_SSO users where Basic Authorization is required for accessing API's

-- include required libraries
local _utils = require("utils")
local _strutils = require("strutils")
local UsersListManager = require("users_list_manager")
local _syslogwriter = require("syslogwriter")


local authorization_url = ngx.var.authorization_url

-- authorization header
local authorization
local ws_auth
local customauthheader = ngx.var.custom_authorization_header

local clientIp = ngx.var.remote_addr

local uri = ngx.var.uri

_utils.isIPBlocked(clientIp)

-- Trim trailing '/'
uri = uri:gsub("/+$", "")
-- Check if uri ends with "CompressedClientLog"
if uri:sub(-#("CompressedClientLog")) == "CompressedClientLog" and uri:match("^/finesse/api/User/.+/") then
    _utils.checkClientLogSize()
elseif uri:match("^/ws$") or uri:match("/socket%.io") then
    ws_auth = _utils.handleWSAuth(uri, clientIp)
    if ws_auth == 0 then
        ngx.log(ngx.DEBUG, "Returned from /ws 0 returning")
        -- this is /ws request and authentication check is disabled.
        return
    end
end


-- Get the custom auth header id present else take from authorization header.
if not _strutils.isEmpty(ws_auth) then
    authorization = ws_auth
elseif _strutils.isEmpty(customauthheader) then
    -- default path if not header found
    authorization = ngx.var.http_authorization
else
    authorization = ngx.var["http_" .. customauthheader]
end

local serverName = _utils.validateServerNames()

-- server_name to which is serving the request
if _strutils.isEmpty(serverName) then
    serverName = ngx.var.server_name
    if serverName == nil then
        serverName = ngx.var.server_addr
    end
end

local serverPort = ngx.var.auth_server_port

-- server_port to which is serving the request
if _strutils.isEmpty(serverPort) then
    serverPort = ngx.var.server_port
end

local authUrl
if _strutils.isEmpty(authorization_url) then
    authUrl = "https://" .. serverName .. ":" .. serverPort .. "/finesse/api/UserAuth"
else
    authUrl = authorization_url
end

-- CSCwo04670 Configure proxy and access Finesse desktop via a load balanced hostname (hostname does not match the internal hostname of the proxy).
-- We cannot rely on the serverName which is coming in the request, as it can be external accessible reverse proxy name
-- we should take the URL from env file, if the value is empty, fallback to the hostname and port from request.
-- The env param will be empty by default, when the deployment has different hostname compare to the reverse proxy internal hostname, this should be used.

local usersURL = "${NGX_FIN_USERS_URL}"

-- backend upstream url which to be used for retrieving list of allowed users
local url

if not usersURL or usersURL == "" then
    url = "https://" .. serverName .. ":" .. serverPort .. "/finesse/api/Users"
else
    url = usersURL
end

-- In case this logic of starting timer fails on openresty starting, the incoming request tries to start the the timer for fetching users.
UsersListManager.getUserList(serverName, serverPort, url)

_utils.start_ids_poller(serverName)

--[[
   check if the request authorization header is not Basic
   if true, then return [As this request is not NON_SSO]
]]
local isBearer = _utils.isBearer(authorization)
local isBasic = _utils.isBasic(authorization)

if isBasic then
    _utils.handleBasicAuth(authUrl, authorization, serverName)
elseif isBearer then
    _utils.handleSSOAuth(authorization, ngx.var.cookie_cc_username)
else
    ngx.log(
        ngx.ERR,
        "Neither basic nor bearer auth header provided. Rejecting request ",
        ngx.var.request,
        " from client ",
        clientIp
    )
    -- Check for brute force attack
    local blockStatus = _utils.checkForBruteforceAttack(clientIp)
    _utils.redirectAndSendError(blockStatus)
end

