--[[
   Checks if the cors headers are populated in the shared dictionary.If populated set all those headers into the response and
   return, else the request is sent to upstream and the headers are populated in cacheoptionrequests lua file.
]]  
    
local _strutils = require("strutils")
local upstreamservername = ngx.var.upstreamservername

 if _strutils.isEmpty(upstreamservername) then
    return
 end
 
local function splitheaders(s, delimiter)
    local result = {};
    for match in (s..delimiter):gmatch("(.-)"..delimiter) do
        table.insert(result, match);
    end
    return result;
end

-- Code to Acquire the lock
  local corsheadersstore = ngx.shared.corsheadersstore  
  local resty_lock = require "resty.lock"
  local lock = resty_lock:new("corsheadersstore")
  local elapsed = lock:lock("corsheaderslock"..upstreamservername)
  if not elapsed then
      ngx.log(ngx.ERR, "Lock held by another request on [", ngx.worker.id(), " ] ")
  end
  
  local responseHeadersStored = corsheadersstore:get(upstreamservername)
    
  -- Check store after acquiring the lock
  if responseHeadersStored ~= nil then 
      local responseHeaders = splitheaders(responseHeadersStored, "\n")
  	  ngx.header["access-control-allow-headers"]  = responseHeaders[1]
  	  ngx.header["access-control-allow-origin"]   =  responseHeaders[2]
  	  ngx.header["access-control-allow-methods"]  =  responseHeaders[3]
  	  ngx.header["access-control-expose-headers"] =  responseHeaders[4]
  	  ngx.header["access-control-allow-credentials"] =  responseHeaders[5]	  
      if ngx.req.get_headers()["Access-Control-Request-Private-Network"] == "true" then
        ngx.header["access-control-allow-private-network"] =  "true"
      end
  	   	 
  	 -- Skip populating the cors header in the store as they are already present.
  	 -- Even though ngx.exit is called, the next phase body_filter_by_lua_file will be called where the context variable should be
  	 -- used to skip populating of the cors headers again in to the shared dictionary.
  	 ngx.ctx.skipPopulatingcorsheaders = true

    local ok, err = lock:unlock()
	  if not ok then
	   	 ngx.log(ngx.ERR, "Failed to unlock from corsheadersstore when the headers are present on [", ngx.worker.id(), " ] ")
	  end
  	 return ngx.exit(ngx.HTTP_OK)
  end
    local ok, err = lock:unlock()
	if not ok then
	   	ngx.log(ngx.ERR, "Failed to unlock from corsheadersstore when the headers are not present on [", ngx.worker.id(), " ] ")
	   	return ngx.HTTP_OK
	end     
